<div class="col-xl-3 mx-auto mt-5 mt-xl-0">
    <div class="rt-sidebar-group">
        <div class="rt-widget final-booking">
            
            <ul>
                @php
                    $groupedPricings = collect($selectedFlightData->travelerPricings)->groupBy('travelerType');
                @endphp
                
                @foreach($groupedPricings as $travelerType => $pricings)
                    <li class="traveler-type text-primary">{{ $travelerType }}</li> <!-- Display traveler type -->
                    @foreach($pricings as $pricing)
                        <li class="clearfix">
                            <span>{{ $travelerType }}</span> <!-- Display traveler type (e.g., Adult, Child) -->
                            <span class="float-right">{{ getCurrencySymbol($selectedFlightData->price->currency) }}{{ $pricing->price->total }} x 1</span> <!-- Display total price for this traveler -->
                        </li>
                        <li class="clearfix">
                            <span>Fare</span>
                            <span class="float-right">{{ getCurrencySymbol($selectedFlightData->price->currency) }}{{ $pricing->price->base }}</span> <!-- Display base fare -->
                        </li>
                        <li class="clearfix">
                            <span>Taxes & Fees</span>
                            <span class="float-right">{{ getCurrencySymbol($selectedFlightData->price->currency) }}{{ $pricing->price->total - $pricing->price->base }}</span> <!-- Calculate and display taxes & fees -->
                        </li>
                    @endforeach
                @endforeach
                <li class="clearfix sub-total">
        
                    <span>Total</span>
                    <span class="float-right"><small>{{ getCurrencySymbol($selectedFlightData->price->currency) }}</small>{{ $selectedFlightData->price->grandTotal }}</span>
                </li>
                
            </ul>
           
        </div><!-- /.rt-widget -->

    </div><!-- /.rt-sidebar-group -->
</div><!-- /.col-lg-3 -->