@extends('frontend.layouts.main')
@section('main-container')

@section('title','flight-Payments')

@php
$paymentIntent=$paymentIntent; 
$getid=$result->id;
@endphp 

<script src="https://js.stripe.com/v3/"></script>   

<div class="rt-breadcump rt-breadcump-height">
    <div class="rt-page-bg rtbgprefix-cover" style="background-image: url({{ asset('assets/frontend/images/backgrounds/bredcump.png') }})">
    </div><!-- /.rt-page-bg -->
    <div class="container">
        <div class="row rt-breadcump-height">
            <div class="col-12">
                <div class="breadcrumbs-content">
                    <h3>Flight</h3>
                    <div class="breadcrumbs">
                        <span class="divider"><i class="icofont-home"></i></span>
                        <a href="#" title="Home">Home</a>
                        <span class="divider"><i class="icofont-simple-right"></i></span>
                        Flight

                    </div><!-- /.breadcrumbs -->
                </div><!-- /.breadcrumbs-content -->
            </div><!-- /.col-12 -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.rt-bredcump -->

<section class="content-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto mx-lg-0">
                <h4 class="rt-strong text-uppercase rt-mb-20">Make Payment For Booking</h4>
            </div><!-- /.col-12 -->
            <div class="col-xl-9 mx-auto col-lg-10">
                <div class="alert rt-alrt-1">
                    <div class="media">
                        <i class="icofont-check mr-2"></i>
                        <div class="media-body">
                            <h6 class="mt-0 rt-semiblod">Make secure payment and have your booking on the go.</h6>
                            Book now so you don't miss out on this price!
                        </div>
                        
                    </div>
                </div><!-- /.alert -->
                @if (session()->has('error'))
                    <div class="alert alert-danger">
                        {!! session('error') !!}

                    </div>
                  @endif 
                <div class="section-title-spacer"></div><!-- /.rt-section-title-spacer -->
               
                <form id="payment-form">

                    <div id="payment-element"></div>

                    <div class="text-center rt-mb-30 mt-5">
           
                        <button type="submit" id="pay-btn" class="rt-btn rt-gradient pill rt-sm has-spinner">
                            <span class="button-text">Continue Booking</span> 
                        </button> 
    
                    </div>

                    <div id="error-messages" class="text-danger"></div>
            
                </form>  
               
             
               
            </div><!-- /.col-lg-9 -->

           @include('frontend.flight.partials.amadeus-proceed-right',['selectedFlightData'=>$selectedFlightData])

        </div><!-- /.row -->
    </div><!-- /.container -->
</section>

<script>
    const stripe=Stripe('{{ $paymentData["public_key"] }}');
    const elements =stripe.elements({
        clientSecret:'{{ $paymentIntent->client_secret }}'
    })
    const paymentElement=elements.create('payment')
    paymentElement.mount('#payment-element')
    const form=document.getElementById('payment-form')
    const payButton = document.getElementById('pay-btn');
    const messages = document.getElementById('error-messages');

    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        messages.innerText = '';
        const { error } = await stripe.confirmPayment({
            elements,
            confirmParams: {
                return_url: window.location.href.split('?')[0] = '{{route("/payment-proceed",$getid)}}'
            }
        });

        if (error) {
            messages.innerText = error.message;
            $('#pay-btn').prop('disabled', false).removeClass('loading');

        } 
    });

</script>
@endsection
