@extends('frontend.layouts.main')
@section('main-container')

@section('title','flight-details')
       
<div class="rt-breadcump rt-breadcump-height">
    <div class="rt-page-bg rtbgprefix-cover" style="background-image: url({{ asset('assets/frontend/images/backgrounds/bredcump.png') }})">
    </div><!-- /.rt-page-bg -->
    <div class="container">
        <div class="row rt-breadcump-height">
            <div class="col-12">
                <div class="breadcrumbs-content">
                    <h3>Flight</h3>
                    <div class="breadcrumbs">
                        <span class="divider"><i class="icofont-home"></i></span>
                        <a href="#" title="Home">Home</a>
                        <span class="divider"><i class="icofont-simple-right"></i></span>
                        Flight

                    </div><!-- /.breadcrumbs -->
                </div><!-- /.breadcrumbs-content -->
            </div><!-- /.col-12 -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.rt-bredcump -->

<section class="content-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto mx-lg-0">
                <h4 class="rt-strong text-uppercase rt-mb-20"> Review your trip </h4>
            </div><!-- /.col-12 -->
            <div class="col-xl-9 mx-auto col-lg-10">
                <div class="alert rt-alrt-1">
                    <div class="media">
                        <i class="icofont-check mr-2"></i>
                        <div class="media-body">
                            <h6 class="mt-0 rt-semiblod">Nice Job! You picked one of our best value flights.</h6>
                            Book now so you don't miss out on this price!
                        </div>
                        
                    </div>
                </div><!-- /.alert -->
                @if (session()->has('error'))
                    <div class="alert alert-danger">
                        {!! session('error') !!}

                    </div>
                  @endif 
                <div class="section-title-spacer"></div><!-- /.rt-section-title-spacer -->
                @foreach ($selectedFlightData->itineraries as $itiKey => $itineraries)
                    
                <div class="flt-dtls-box rt-mb-30">
                    <div class="upper-top-content d-md-flex flex-md-row justify-content-md-between align-items-center">
                        <div class="left">

                            @if ($itiKey==0)
                            <span>{{ session('searchParams.departure_full') }}</span> <span><img src="{{asset('assets/frontend/images/all-img/shp-ln-1.png')}}" alt="line image" draggable="false"></span> <span>{{ session('searchParams.arrival_full') }}</span>
                            <p>{{ session('searchParams.departure_date') }}
                            @else
                            <span>{{ session('searchParams.arrival_full') }}</span> <span><img src="{{asset('assets/frontend/images/all-img/shp-ln-1.png')}}" alt="line image" draggable="false"></span> <span>{{ session('searchParams.departure_full') }}</span>
                            <p>{{ session('searchParams.return_date') }} 
                            @endif

                         | {{ session('searchParams.adult') }} Adult , {{ session('searchParams.child') }} Child , {{ session('searchParams.infant') }} Infant
                                
                           </p>
                        </div><!-- /.left -->
                        {{-- <div class="right">
                            <a href="#" class="rt-btn rt-gradient3 rt-Bshadow-3  pill text-uppercase rt-sm2">Update</a>
                        </div> --}}
                    </div><!-- /.upper-top-content -->
                    @foreach ($itineraries->segments as $segKey => $segment)

                    <div class="flight-list-box">
                        <div
                            class="top-content d-flex flex-lg-row flex-column align-items-lg-center justify-content-left  justify-content-lg-between">
                            <div class="flight-logo">
                                <img src="{{ url('assets/frontend/images/airlines/'.$segment->carrierCode) }}.png" alt="flt logo" draggable="false">
                            </div><!-- /.flight-logo -->
                            <div class="pricing">
                                <h5>{{ $dictionaries->carriers->{$segment->carrierCode} }}</h5>
                                <p>{{ $segment->carrierCode .$segment->number }} | {{ $dictionaries->aircraft->{$segment->aircraft->code} }}</p>
                            </div><!-- /.pricing -->
                            <div class="flight-time d-flex justify-content-between align-items-center">
                                <div class="left">
                                    <span class="d-block">{{ formatTime($segment->departure->at,'H:i') }}</span>
                                    <span class="d-block">{{ $segment->departure->iataCode }}</span>
                                </div><!-- /.left -->
                                <div class="middle">
                                    <img src="{{ asset('assets/frontend/images/all-img/time-shape-line.png') }}" alt="time shape" draggable="false">
                                </div><!-- /.middle -->
                                <div class="right">
                                    <span class="d-block">{{ formatTime($segment->arrival->at,'H:i') }}</span>
                                    <span class="d-block">{{ $segment->arrival->iataCode }}</span>
                                </div><!-- /.rght -->
                            </div><!-- /.flight-time -->
                            <div class="flight-detils">
                                <span class="d-block"><i class="icofont-clock-time"></i><!-- /.time -->{{ formatDuration($segment->duration) }}</span>
                                <span class="d-block"><a href="#collapseExample-{{ $itiKey }}-{{ $segKey }}" class="flt-d-clic" data-toggle="collapse" role="button"
                                        aria-expanded="false" aria-controls="collapseExample-{{ $itiKey }}-{{ $segKey }}">Flight details <i
                                            class="icofont-simple-down"></i></a></span>
                            </div><!-- /.flight-detils -->
                          
                           
                        </div><!-- /.top-content -->
                        <div class="collapse bottom-content" id="collapseExample-{{ $itiKey }}-{{ $segKey }}" style="width:100%">
                            <p><span>{{ $dictionaries->carriers->{$segment->carrierCode} }} - {{ $segment->carrierCode .$segment->number }} | {{ $dictionaries->aircraft->{$segment->aircraft->code} }} | {{ $selectedFlightData->travelerPricings[0]->fareDetailsBySegment[0]->cabin }}</span> <span><i class="icofont-clock-time"></i>{{ formatDuration($segment->duration) }}</span></p>
                            <ul class="flight-timeline" style="width:100%">
                        
                                <li>
                                    <span>{{ formatTime($segment->departure->at,'M d Y H:i') }}</span>
                                    <br>
                                    <span>{{ $segment->departure->iataCode }}</span>
                        
                                </li>
                                {{-- <li><span>{{ $segment->departure->iataCode }}</span></li> --}}
                                <li>
                                    <span>{{ formatTime($segment->arrival->at,'M d Y H:i') }}</span>
                                    <br>
                                    <span>{{ $segment->arrival->iataCode }}</span>
                        
                                </li>
                                {{-- <li><span>{{ $segment->arrival->iataCode }}</span></li> --}}
                            </ul>
                        </div><!-- /.bottom content -->
                    </div><!-- /.flight-list-box -->

                    @endforeach
                </div><!-- /.flt-dtls-box -->

                @endforeach
                @if (!auth()->user())
                    
                <div class="flight-list-box rt-mb-30 ask-for-login d-md-flex flex-md-row justify-content-md-between align-items-center pt-30">
                    <div class="left">
                        <h6 class="rt-strong">Already a member?</h6>
                        <p>Sign in to make booking easier!</p>
                    </div><!-- /.left -->
                    <div class="right">
                        <a href="#" class="link-text rt-strong f-size-14" data-toggle="modal" data-target="#rtmodal-1"> <i class="fa fa-user icon-share icon-gradinet-1 rt-circle mr-2"></i><!-- /.fa -->  Sign in</a>
                    </div><!-- /.left -->
                </div><!-- /.flight-list-box -->
                @endif

                <form action="{{ route('/flight-form') }}" class="rt-form rt-line-form flight-lable" method="post">
                    @csrf

                <div class="flight-list-box rt-mb-30 pt-30">
                    <h4 class="f-size-24 text-capitalize rt-mb-30  rt-semiblod">Passenger Info</h4>

                    @foreach ($selectedFlightData->travelerPricings as $tKey => $traveler)

                    <h6 class="text-333 rt-medium">Passenger {{ $tKey + 1 }}: {{ $traveler->travelerType }}</h6>
                    <br>
                    <br>
                    <input type="hidden" name="passType[]" value="{{ $traveler->travelerType }}">
                        <div class="row">
                            <div class="col-md-6 rt-mb-30 ">
                                <label for="fst-name">First Name</label>
                                <input type="text" class="form-control" id="fst-name" placeholder="Enter  Passenger First Name " name="first_name[]" value="{{ old('first_name.' . $tKey) }}">
                                <x-input-error :messages="$errors->get('first_name.' . $tKey)" class="mt-2" />
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6 rt-mb-30">
                                <label for="lst-name">Last Name</label>
                                <input type="text" class="form-control" id="lst-name" placeholder="Enter Passenger Last Name " name="last_name[]" value="{{ old('last_name.' . $tKey) }}">
                                <x-input-error :messages="$errors->get('last_name.' . $tKey)" class="mt-2" />
                            </div><!-- /.col-md-6 -->
                            <div class="col-lg-6 rt-mb-30">
                                <label for="select-1"></label>
                                <select id="select-1" name="country[]">
                                    <option value=""  selected>Select birth country</option>
                                    @foreach ($countries as $country)

                                    <option value="{{ $country->shortname }}" {{ old('country.' . $tKey) == $country->shortname ? 'selected' : '' }}>{{ $country->name }}

                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('country.' . $tKey)" class="mt-2" />

                            </div><!-- /.col-md-6 -->
                            <div class="col-lg-6 rt-mb-30">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label>Gender</label>
                                        <br>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="gender[]" id="inlineRadio2ss" value="Male" checked>
                                            <label class="form-check-label" for="inlineRadio2ss">Male</label>
                                        </div>

                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="gender[]" id="inlineRadio2s" value="Female">
                                            <label class="form-check-label" for="inlineRadio2s">Female</label>
                                        </div>
                                        <x-input-error :messages="$errors->get('gender.' . $tKey)" class="mt-2" />
                                    </div><!-- /.col-md-6 -->
                                    <div class="col-md-6">
                                        <label for="st-date">Date of birth</label>
                                        <input type="text" class="form-control rt-date-picker" placeholder="date" name="dob[]" value="{{ old('dob.' . $tKey) }}">
                                        <x-input-error :messages="$errors->get('dob.' . $tKey)" class="mt-2" />
                                    </div><!-- /.col-md-6 -->
                                </div><!-- /.row -->
                            </div><!-- /.col-md-6 -->
                          
                            <div class="col-md-4 rt-mb-30">
                                <label for="id-number">Passport Number</label>
                                <input type="text" placeholder="Enter Passport Number" class="form-control" name="pidno[]" value="{{ old('pidno.' . $tKey) }}">
                                <x-input-error :messages="$errors->get('pidno.' . $tKey)" class="mt-2" />
                            </div><!-- /.col-md-6 -->

                            <div class="col-md-4">
                                <label for="st-date">Expiry Date</label>
                                <input type="text" class="form-control rt-date-picker" placeholder="date" data-min="today" name="pied[]" value="{{ old('pied.' . $tKey) }}">
                                <x-input-error :messages="$errors->get('pied.' . $tKey)" class="mt-2" />

                            </div>

                            <div class="col-lg-4 rt-mb-30">
                                <label for="select-issue-country"></label>
                                <select id="select-issue-country" name="passport_country[]">
                                    <option value=""  selected>Select pssport issue country</option>
                                    @foreach ($countries as $country)

                                    <option value="{{ $country->shortname }}" {{ old('passport_country.' . $tKey) == $country->shortname ? 'selected' : '' }}>{{ $country->name }}

                                    @endforeach

                                </select>
                                <x-input-error :messages="$errors->get('passport_country.' . $tKey)" class="mt-2" />

                            </div><!-- /.col-md-6 -->
                            
                        </div>
                        
                    @endforeach
                    
                </div><!-- /.flight-list-box -->
                <div class="flight-list-box rt-mb-30 pt-30">
                    <h6 class="text-333 rt-semiblod">Contact Details</h6> <br>
                   
                       <div class="row">
                            <div class="col-md-6 rt-mb-30">
                                <label for="contact-name">Contact name</label>
                                <input type="text" placeholder="Contact name" id="contact-name" name="name" value="{{ old('name') }}">
                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6 rt-mb-30">
                                <label for="mbl-name">Mobile phone</label>
                                <input type="tel" placeholder="Enter Your Number" id="mbl-name" name="contact_no" value="{{ old('contact_no') }}">
                                <x-input-error :messages="$errors->get('contact_no')" class="mt-2" />
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <label for="eml-name">Email</label>
                                <input type="tel" placeholder="Enter Your Email" id="eml-name" name="email" value="{{ old('email') }}">
                                <x-input-error :messages="$errors->get('email')" class="mt-2" />

                            </div><!-- /.col-md-6 -->
                       </div><!-- /.row -->
                </div><!-- /.flight-list-box -->

                <span class="f-size-12 line-height-12">By proceeding, I acknowledge that I
                    have read and agree to 
                    <a href="#">Terms of Use</a> and <a href="#">Privacy Statement.</a></span>
                <div class="text-center rt-mb-30">
                   

                    <button type="submit" class="rt-btn rt-gradient pill rt-sm has-spinner">
                        <span class="button-text">Continue Booking</span> 
                    </button> 
                </div><!-- /.text-center -->
               

               </form>

                {{-- <div class="flight-list-box pt-30">
                    <h4 class="f-size-24 rt-strong rt-mb-20">Promo Code</h4>
                    <form action="" class="rt-form rt-line-form flight-lable">
                        <div class="row align-items-end">
                            <div class="col-md-6">
                                <label>Add promo code</label>
                                <input type="text" placeholder="Please enter promo code">
                            </div><!-- /.col-md-6 -->
                            <div class="col-md-6">
                                <a href="#" class="rt-btn rt-gradient3 pill text-uppercase ">Verify</a>
                            </div><!-- /.col-md- -->
                        </div><!-- /.row -->
                    </form>
                </div> --}}
            </div><!-- /.col-lg-9 -->

           @include('frontend.flight.partials.amadeus-proceed-right',['selectedFlightData'=>$selectedFlightData])

        </div><!-- /.row -->
    </div><!-- /.container -->
</section>
@endsection
