@extends('frontend.layouts.main')
@section('main-container')

@section('title','flight-success')

 

<div class="rt-breadcump rt-breadcump-height">
    <div class="rt-page-bg rtbgprefix-cover" style="background-image: url({{ asset('assets/frontend/images/backgrounds/bredcump.png') }})">
    </div><!-- /.rt-page-bg -->
    <div class="container">
        <div class="row rt-breadcump-height">
            <div class="col-12">
                <div class="breadcrumbs-content">
                    <h3>Flight</h3>
                    <div class="breadcrumbs">
                        <span class="divider"><i class="icofont-home"></i></span>
                        <a href="#" title="Home">Home</a>
                        <span class="divider"><i class="icofont-simple-right"></i></span>
                        Flight

                    </div><!-- /.breadcrumbs -->
                </div><!-- /.breadcrumbs-content -->
            </div><!-- /.col-12 -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.rt-bredcump -->

<section class="content-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 mx-auto mx-lg-0">
                <h4 class="rt-strong text-uppercase rt-mb-20">{{ $ticketDetails->payment_status=='completed' ? 'Payment Completed' : 'Payment Error' }}</h4>
            </div><!-- /.col-12 -->
            <div class="col-xl-12 mx-auto col-lg-12">
                <div class="alert rt-alrt-1">
                    <div class="media">
                        <i class="icofont-check mr-2"></i>
                        <div class="media-body">
                            <h6 class="mt-0 rt-semiblod">{{ $ticketDetails->payment_status=='completed' ? 'Your Payment has been confirmed.' : 'Payment Error' }}</h6>
                           
                        </div>
                        
                    </div>
                </div><!-- /.alert -->
               
                <div class="section-title-spacer"></div><!-- /.rt-section-title-spacer -->
               
                <table class="table">
                    <thead>
                      <tr>
                       <th>Ref-PNR</th>
                        <th scope="col">Name</th>
                        <th scope="col">Flight Type</th>
                        <th scope="col">Destination</th>
                        <th scope="col">Amount Paid</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td>{{ $ticketDetails->pnr_no }}</td>
                       <td>{{ $ticketDetails->p_name }}</td>
                       <td>{{ $ticketDetails->p_name }}</td>
                       <td>{{ $ticketDetails->destinations }}</td>
                       <td>{{ $ticketDetails->paid_amount_currency }}{{ $ticketDetails->paid_amount }}</td>
                      </tr>
                     
                    </tbody>
                  </table>


               
            </div><!-- /.col-lg-9 -->

          
        </div><!-- /.row -->
    </div><!-- /.container -->
</section>

@endsection
