<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title','Emigrar')</title>
    <link rel="icon" type="image/png" href="assets/images/favicon.png">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- ==================Start Css Link===================== -->
    <link href="https://fonts.googleapis.com/css?family=Lato&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/animate.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/OverlayScrollbars.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/fontawesome.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/icofont.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/magnific-popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/owl.theme.default.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/owl.carousel.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/slider-range.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/tippy.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/custom.css') }}">
    <!-- ==================End Css Link===================== -->
    @yield('styles')
    <style>
         .ui-datepicker-prev{
        background-image: url('{{ asset("assets/frontend/images/ui-icons_444444_256x240.png") }}') !important;
        background-repeat: no-repeat
        }
        .ui-datepicker-next{
            background-image: url('{{ asset("assets/frontend/images/ui-icons_444444_256x240.png") }}') !important;
            background-repeat: no-repeat;
            rotate: 180deg;
        }
    </style>
    <script>
        baseUrl = "{{ url('') }}"
    </script>
  
</head>


<body>


    <!--
        ================== Header Area Start===================
     -->


    <header class="rt-site-header  rt-fixed-top black-menu">
        <div class="top-header d-none d-md-block">
            <div class="container">
                <div class="row align-items-center">
                   
                    <div class="col-md-6">
                        <ul class="text-center text-md-right top-social">
                        
                            @if (!auth()->user())
                               
                                <li style="color:black!important"><a style="color:black!important" href="{{ url('/dashboard') }}" >
                                <i class="far fa-user-circle"></i>Sign in</a></li>
                                
                            @else
                               
                                <li style="color:black!important"><a href="{{ route('dashboard') }}">
                                <i class="far fa-user-circle"></i>Dashboard</a></li>
                            @endif
                           
                        </ul>
                    </div><!-- end top header single -->
                </div>
            </div>
        </div> <!-- end top header -->


       

    </header>


    <!-- Modal -->
    <div class="modal fade" id="rtmodal-1" tabindex="-1" role="dialog" aria-labelledby="rtmodal-1"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered rt-lgoinmodal " role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="rt-modal-headr rt-mb-20 one">
                        <img src="{{ asset('assets/frontend/images/logo/Logo-icon.png') }}" alt="modal logo"
                            draggable="false">
                        <h4>Login in to Emigrar</h4>
                        <p>Log in to get in the moment updates on the things
                            that interest you.</p>
                    </div><!-- /.rt-modal-headr -->
                    <div class="rt-modal-headr rt-mb-20 two">
                        <img src="{{ asset('assets/frontend/images/logo/Logo-icon.png') }}" alt="modal logo"
                            draggable="false">
                        <h4>Create your Account</h4>
                        <p>Create your account and start the journey.</p>
                    </div><!-- /.rt-modal-headr -->
                    <div class="rt-modal-input one">
                        <form action="{{ route('login') }}" class="rt-form" id="login-form" method="post">
                                @csrf
                                <p class="text-danger message-box"></p>

                            <input type="text" class="form-control pill rt-mb-15" placeholder="Email" name="email" required>

                            <input type="password" class="form-control pill rt-mb-15" placeholder="Password" name="password" required>

                           
                            <button type="submit" class="has-spinner rt-gradient pill d-block text-uppercase rt-btn">
                                <span class="button-text">Log In</span> 
                            </button>
                        </form>
                        <div class="ac-register">
                            <span>Don’t have an account? <a href="#" class="open-creatac">Sign Up Now <i
                                        class="icofont-double-right"></i></a></span>
                        </div><!-- /.ac-register -->
                    </div><!-- /.rt-modal-input -->
                    <div class="rt-modal-input two">
                        <form action="{{ route('register') }}" class="rt-form" method="post" id="signup-form">
                            @csrf

                            <p class="text-danger message-box"></p>

                            <input type="text" class="form-control pill rt-mb-15" placeholder="User name" name="name" required>

                            <input type="text" class="form-control pill rt-mb-15" placeholder="Email" name="email" required>

                            <input type="password" class="form-control pill rt-mb-15" placeholder="Password" name="password" required>
                            <div class="form-group forgot-pass">
                              
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck222" required>
                                    <label class="form-check-label" for="gridCheck222">
                                        By clicking "Sign up" you agree to our Terms of Service and Privacy Policy
                                    </label>
                                </div><!-- ./orm-group -->
                            </div>
                          
                                <button type="submit" class="has-spinner rt-gradient pill d-block text-uppercase rt-btn">
                                    <span class="button-text">Sign Up</span> 
                                </button>
                        </form>
                        <div class="ac-register">
                            <span>Already have an account?<a href="#" class="open-login">LOGIN <i
                                        class="icofont-double-right"></i></a></span>

                        </div><!-- /.ac-register -->
                    </div><!-- /.rt-modal-input -->
                    <div class="rt-modal-footer">
                        <span>Or</span>
                        <h4>Sign Up with social media</h4>
                        <ul class="rt-social rt-circle-style2">

                            <li><a href="#"><i class="icofont-facebook"></i></a></li>
                            <li><a href="#"><i class="icofont-twitter"></i></a></li>
                            <li><a href="#"><i class="icofont-linkedin"></i></a></li>
                        </ul>
                    </div><!-- /.rt-modal-footer -->
                </div>
            </div>
        </div>
    </div>
