@extends('frontend.layouts.main')
@section('main-container')

@section('title','contact-us')
<!-- ========== MAIN CONTENT ========== -->
<div class="rt-breadcump rt-breadcump-height">
    <div class="rt-page-bg rtbgprefix-cover" style="background-image: url({{ asset('assets/frontend/images/backgrounds/bredcump.png') }})">
    </div><!-- /.rt-page-bg -->
    <div class="container">
        <div class="row rt-breadcump-height">
            <div class="col-12">
                <div class="breadcrumbs-content">
                    <h3>Contact Us</h3>
                    <div class="breadcrumbs">
                        <span class="divider"><i class="icofont-home"></i></span>
                        <a href="#" title="Home">Home</a>
                        <span class="divider"><i class="icofont-simple-right"></i></span>
                        Contact Us

                    </div><!-- /.breadcrumbs -->
                </div><!-- /.breadcrumbs-content -->
            </div><!-- /.col-12 -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.rt-bredcump -->


<section class="contact-area">
    <div class="rt-design-elmnts rtbgprefix-contain" style="background-image: url({{ asset('assets/frontend/images/all-img/abt_vec_3.png') }})">

    </div><!-- /.rt-design-elmnts -->
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <div class="rt-section-title-wrapper">
                    <h2 class="rt-section-title">
                        <span>Contact us</span>
                        
                        Get In Touch
                    </h2><!-- /.rt-section-title -->
                    <p>Any kind of travel information don't hesitate to contact with us for imiditate
                    customer support. We are love to hear from you</p>
                    <div class="section-title-spacer"></div><!-- /.section-title-spacer -->
                   
                    @if (session()->has('success'))
                    <div class="alert alert-success">
                        {!! session('success') !!}
  
                    </div>
                    @endif 
                    <form action="{{ route('contactSave') }}" method="post" class="rt-form rt-line-form">
                        @csrf
                        <input type="text" placeholder="Name" class="form-control rt-mb-30" name="name">
                        <x-input-error :messages="$errors->get('title')" class="mt-2" />

                        <input type="email" placeholder="Email" class="form-control rt-mb-30" name="email">
                        <x-input-error :messages="$errors->get('title')" class="mt-2" />

                        <textarea placeholder="Message" class="form-control rt-mb-30" name="message"></textarea>
                        <x-input-error :messages="$errors->get('title')" class="mt-2" />

                        <input type="submit" value="SUBMIT NOW" class="rt-btn rt-gradient pill text-uppercase rt-mb-30">
                        
                    </form>
                </div><!-- /.rt-section-title-wrapper -->
            </div><!-- /.col-lg-9 -->
        </div><!-- /.row -->
        <div class="section-title-spacer"></div><!-- /.section-title-spacer -->
    </div><!-- /.container -->
</section>


<section class="rt-map-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 mx-auto col-md-6">
                <div class="rt-single-icon-box icon-center text-center justify-content-center shdoaw-style wow fadeInUp">
                    <div class="icon-thumb">
                        <img src="{{ asset('assets/frontend/images/icons-image/con-1.png') }}" alt="box-icon" draggable="false">
                    </div><!-- /.icon-thumb -->
                    <div class="iconbox-content">
                        <h5>Our Address</h5>
                        
                        <p>{{ getContactDetails()->address }}<br>. </p>
                    </div><!-- /.iconbox-content -->
                </div><!-- /.rt-single-icon-box -->
            </div><!-- /.col-lg-4 -->
            <div class="col-lg-4 mx-auto col-md-6">
                <div class="rt-single-icon-box icon-center text-center justify-content-center shdoaw-style wow fadeInUp" data-wow-duration="1.5s">
                    <div class="icon-thumb">
                        <img src="{{ asset('assets/frontend/images/icons-image/con-2.png') }}" alt="box-icon" draggable="false">
                    </div><!-- /.icon-thumb -->
                    <div class="iconbox-content">
                        <h5>Phone & Email</h5>
                        <p>{{ getContactDetails()->phone }} <br>
                            {{ getContactDetails()->email }}</p>
                    </div><!-- /.iconbox-content -->
                </div><!-- /.rt-single-icon-box -->
            </div><!-- /.col-lg-4 -->
            <div class="col-lg-4 mx-auto col-md-6">
                <div class="rt-single-icon-box icon-center text-center justify-content-center shdoaw-style wow fadeInUp" data-wow-duration="2s">
                    <div class="icon-thumb">
                        <img src="{{ asset('assets/frontend/images/icons-image/con-3.png') }}" alt="box-icon" draggable="false">
                    </div><!-- /.icon-thumb -->
                    <div class="iconbox-content">
                        <h5>Stay In Touch</h5>
                        <ul class="rt-social rt-circle-style">
                        @foreach(json_decode(getSiteIdentity()->social_links) as $key => $value)

                            <li><a href="#"><i class="{{ getSocialMediaIconClass($value->social_name) }}"></i></a></li>
                           
                        @endforeach
                          

                        </ul>
                    </div><!-- /.iconbox-content -->
                </div><!-- /.rt-single-icon-box -->
            </div><!-- /.col-lg-4 -->
        </div><!-- /.row -->
    </div><!-- /.container -->
    <div class="googleMap">
        <iframe
            src="{{ getContactDetails()->maps_address }}"
            width="100%" height="582" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
    </div>
</section>
<!-- ========== END MAIN CONTENT ========== -->
@endsection

