@extends('backend.layouts.main')
@section('title', 'User-Balance')

@section('main-container')
  
  
<div class="pcoded-content">
  <div class="pcoded-inner-content">
      <!-- Main-body start -->
      <div class="main-body">
          <div class="page-wrapper">
              <!-- Page-header start -->
              <div class="page-header">
                  <div class="row align-items-end">
                      <div class="col-lg-8">
                          <div class="page-header-title">
                              <div class="d-inline">
                                  <h4>All User's Balance List</h4>
                                  
                              </div>
                          </div>
                         
                      </div>
                      <div class="col-lg-4">
                          <div class="page-header-breadcrumb">
                              <ul class="breadcrumb-title">
                                  <li class="breadcrumb-item">
                                      <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="#!">User Balance</a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="">All</a>
                                  </li>
                              </ul>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Page-header end -->
                  
                  <div class="page-body">
                   
                    <div class="card">
                      <div class="card-header">
                          <h5 class="card-header-text">User Balance</h5>
                          <a href="{{route('user-balance.create')}}" class="btn btn-primary adn-50 adn-right float-right">
                            <i class="icofont icofont-plus"></i>Create New  
                          </a>
                      </div>
                      <div class="card-block contact-details">
                          <div class="data_table_main table-responsive dt-responsive">
                              <table id="simpletable" class="table  table-striped table-bordered nowrap">
                                  <thead>
                                      <tr>
                                          <th>User</th>
                                          <th>Current Balance</th>
                                          <th>Last Updated</th>
                                          <th>Updated By</th>
                                          <th>Last Balance</th>
                                         
                                          @if (auth()->user()->hasPermissionTo('manage all deposits')) 
                                          <th>Action</th>
                                          @endif

                                      </tr>
                                  </thead>
                                  <tbody>
                                    @foreach ($balances as $key=> $balance)
                                        
                                      <tr>
                                          <td>
                                            @if (auth()->user()->hasPermissionTo('manage all transactions'))
                                            <a href="{{route('users.edit',$balance->user->id)}}" class="text-primary">{{$balance->user->name}}</a>
                                            @else
                                            <a href="{{route('profile.edit')}}" class="text-primary">{{$balance->user->name}}</a>
                                            @endif
                                          </td>

                                          <td>{{$balance->balance_amount}} - {{ $balance->currency_code }}</td>

                                          <td>{{$balance->updated_at->format('d M Y h:i a')}}</td>

                                          <td>{{ $balance->updatedBy->name }}</td>

                                          <td>{{ $balance->last_balance }} - {{ $balance->currency_code }}</td>
                                        
                                      @if (auth()->user()->hasPermissionTo('manage all transactions')) 

                                          <td class="dropdown">
                                              <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-cog" aria-hidden="true"></i></button>
                                              <div class="dropdown-menu dropdown-menu-right b-none contact-menu">
                                                  <a class="dropdown-item" href="{{route('userBalance.add',$balance->user->id)}}"><i class="icofont icofont-plus"></i>Credit Balance</a>
                                                  
                                                  <a class="dropdown-item" href="{{route('userBalance.remove',$balance->user->id)}}"><i class="icofont icofont-minus"></i>Debit Balance</a>

                                              </div>
                                             
                                          </td>
                                          @endif
                                      </tr>
                                    @endforeach



                                  </tbody>

                              </table>
                          </div>
                      </div>
                  </div>

                  </div>
              </div>
          </div>
          <!-- Warning Section Starts -->
          <div id="styleSelector">

          </div>
      </div>
  </div> 


  @endsection
