
@if(!empty($data))
<?php

$tripType = $data['trip_type'] ?? '';
$departureFull = $data['departureFull'] ?? '';
$arrivalFull = $data['arrivalFull'] ?? '';
$departureCode = $data['departureCode'] ?? '';
$arrivalCode = $data['arrivalCode'] ?? '';
$departureDate = $data['departureDate'] ?? '';
$returnDate = $data['returnDate'] ?? '';
$adult = $data['adult'] ?? 1;
$child = $data['child'] ?? 0;
$infant = $data['infant'] ?? 0;
$travelClass = $data['travel_class'] ?? ''; 
$totalPax = $adult + $child + $infant;

?>
@else
<?php
// Set default values
$tripType = 'return';
$departureFull = '';
$arrivalFull = '';
$departureCode = '';
$arrivalCode = '';
$departureDate = '';
$returnDate = '';
$adult = 1;
$child = 0;
$infant = 0;
$travelClass = 'Economy';
$totalPax = 1;


?>

@endif


<form action="{{ route('flight-list') }}">
    <input type="hidden" name="departure_code" id="departure_code" value="{{ $departureCode }}">
    <input type="hidden" name="arrival_code" id="arrival_code" value="{{ $arrivalCode }}">
    <div class="rt-radio-group">
        <div class="custom-control custom-radio custom-control-inline">
            <input type="radio" id="customRadioInline1" name="trip_type"
                class="custom-control-input single_round"  data-value="Single" value="oneway" {{ $tripType=='oneway' ? 'checked' : '' }}>
            <label class="custom-control-label"
                for="customRadioInline1">One-way</label>
        </div>
        <div class="custom-control custom-radio custom-control-inline">
            <input type="radio" id="customRadioInline2" name="trip_type"
                class="custom-control-input single_round" data-value="Round" value="return" {{ $tripType=='return' ? 'checked' : '' }}>
            <label class="custom-control-label"
                for="customRadioInline2">Round-trip</label>
        </div>
       

        <div class="dropdown form-check-inline rt-searchlink ">
           
            <select name="travel_class" id="" class="custom-select-site">
            <option value="Economy" {{ $travelClass=='Economy' ? 'selected' : '' }}>Economy</option>
            <option value="Business" {{ $travelClass=='Business' ? 'selected' : '' }}>Business</option>
            <option value="First" {{ $travelClass=='First' ? 'selected' : '' }}>First</option>

        </select>
        </div>
        <div class="dropdown form-check-inline rt-searchlink">
            <div class="dropdown-toggle mx-3" id="show-passenger-box">
                Select Passengers
            </div>
        
            <div id="passenger-box" class="passenger-box">
                <div id="adult" class="passenger-row">
                    <div class="label-wrapper">
                        <label>Adult</label>
                    </div>
                    <div class="controls-wrapper">
                        <button class="minus" type="button" onclick="decreaseCount('adult')">-</button>
                        <input type="number" id="adult-count" value="{{ $adult }}" readonly name="adult">
                        <button class="plus" type="button" onclick="increaseCount('adult')">+</button>
                    </div>
                </div>
                <div id="child" class="passenger-row">
                    <div class="label-wrapper">
                        <label>Child</label>
                    </div>
                    <div class="controls-wrapper">
                        <button class="minus" type="button" onclick="decreaseCount('child')">-</button>
                        <input type="number" id="child-count" value="{{ $child }}" readonly name="child">
                        <button class="plus" type="button" onclick="increaseCount('child')">+</button>
                    </div>
                </div>
                <div id="infant" class="passenger-row">
                    <div class="label-wrapper">
                        <label>Infant</label>
                    </div>
                    <div class="controls-wrapper">
                        <button class="minus" type="button" onclick="decreaseCount('infant')">-</button>
                        <input type="number" id="infant-count" value="{{ $infant }}" readonly name="infant">
                        <button class="plus" type="button" onclick="increaseCount('infant')">+</button>
                    </div>
                </div>
                <div id="total-count" class="total-count">Total: <span id="total">{{ $totalPax }}</span></div>
            </div>
            
        </div>
    </div><!-- /.radio-group -->
    <div class="rt-input-group">
        <div class="single-input  col-rt-in-3">

            <input type="text" class="form-control search-input has-icon"
                placeholder="From" id="departure" autocomplete="off" required name="departure_full" value="{{ $departureFull }}">

            <span class="input-iconbadge"><img
                    src="{{ asset('assets/frontend/images/icons-image/s_icon_1.png') }}"
                    alt="" draggable="false">
            </span>


        </div><!-- /.single-input -->
        <div class="single-input  col-rt-in-3">
            <input type="text" class="form-control search-input has-icon"
            placeholder="From" id="arrival" autocomplete="off" required name="arrival_full" value="{{ $arrivalFull }}">
            <span class="input-iconbadge"><img
                    src="{{ asset('assets/frontend/images/icons-image/s_icon_2.png') }}"
                    alt="" draggable="false">
            </span>
        </div><!-- /.single-input -->
        <div class="single-input  col-rt-in-3">
            <input type="text" class="form-control has-icon"
                placeholder="Depart" autocomplete="off" name="departure_date" id="check_in_date" required value="{{ $departureDate }}">
            <span class="input-iconbadge"><i
                    class="icofont-ui-calendar"></i></span>
        </div><!-- /.single-input -->
        <div class="single-input  col-rt-in-3 {{ $tripType=='oneway' ? 'opacity-0' : 'opacity-1' }}" id="return_date_element" >
            <input type="text" class="form-control has-icon"
                placeholder="Return" name="return_date" id="check_out_date"  autocomplete="off" value="{{ $returnDate }}">
            <span class="input-iconbadge"><i
                    class="icofont-ui-calendar"></i></span>
        </div><!-- /.single-input -->
        <div class="single-input  col-rt-in-1">
            <button type="submit" class="has-spinner">
                <span class="button-text"><i class="icofont-search"></i></span> 
            </button>
        </div><!-- /.single-input -->
    </div><!-- /.rt-input-group -->
</form>

@section('scripts')
<script>
    let counts = {
        adult: {{ $adult }},
        child: {{ $child }},
        infant: {{ $infant }}
    };

    function updateTotal() {
        const total = counts.adult + counts.child + counts.infant;
        document.getElementById('total').textContent = total;
    }

    function increaseCount(type) {
        counts[type]++;
        document.getElementById(type + '-count').value = counts[type];
        updateTotal();
    }

    function decreaseCount(type) {
        if (type === 'adult') {
            if (counts.adult > 1) { // Check if count is greater than 1
                counts.adult--;
                document.getElementById('adult-count').value = counts.adult;
                updateTotal();
            }
        } else if (counts[type] > 0) { // For other types (child and infant)
            counts[type]--;
            document.getElementById(type + '-count').value = counts[type];
            updateTotal();
        }
    }


    const showPassengerBox = document.getElementById('show-passenger-box');
    const passengerBox = document.getElementById('passenger-box');

    showPassengerBox.addEventListener('click', function(event) {
        if (passengerBox.style.display === 'none' || passengerBox.style.display === '') {
            passengerBox.style.display = 'block';
        } else {
            passengerBox.style.display = 'none';
        }
        event.stopPropagation(); // Prevents the event from bubbling up
    });

    document.addEventListener('click', function(event) {
        const isClickedInside = showPassengerBox.contains(event.target) || passengerBox.contains(event.target);
        if (!isClickedInside) {
            passengerBox.style.display = 'none';
        }
    });

</script> 
@endsection