
@extends('frontend.layouts.main')
@section('main-container')

   @section('title','flight-list-page')

@section('styles')
    
   {{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.4/nouislider.min.css"> --}}

@endsection


<div class="rt-breadcump rt-breadcump-height with-logn-height">
    <div class="rt-page-bg rtbgprefix-cover" style="background-image: url({{ asset('assets/frontend/images/backgrounds/bredcump.png') }})">
    </div><!-- /.rt-page-bg -->
    <div class="container">
        <div class="row rt-breadcump-height with-logn-height">
            <div class="col-12">
                <div class="breadcrumbs-content">
                    <h3>Flight</h3>
                    <div class="breadcrumbs">
                        <span class="divider"><i class="icofont-home"></i></span>
                        <a href="#" title="Home">Home</a>
                        <span class="divider"><i class="icofont-simple-right"></i></span>
                        Flight

                    </div><!-- /.breadcrumbs -->
                </div><!-- /.breadcrumbs-content -->
            </div><!-- /.col-12 -->
        </div><!-- /.row -->
    </div><!-- /.container -->

    <div class="bredcump-search">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="rt-banner-searchbox flight-search wow fade-in-bottom overflow-visible mb-10-rem" data-wow-duration="1s"
                        data-wow-delay="1s">
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane show active" id="rt-item_a_first" role="tabpanel"
                                aria-labelledby="rt-item_a_first">

                                @php
                                        $formData=[
                                            'trip_type'=>session('searchParams.trip_type'),
                                            'departureFull'=>session('searchParams.departure_full'),
                                            'arrivalFull'=>session('searchParams.arrival_full'),
                                            'departureCode'=>session('searchParams.departure_code'),
                                            'arrivalCode'=>session('searchParams.arrival_code'),
                                            'departureDate'=>session('searchParams.departure_date'),
                                            'returnDate'=>session('searchParams.return_date'),
                                            'adult'=>session('searchParams.adult'),
                                            'child'=>session('searchParams.child'),
                                            'infant'=>session('searchParams.infant'),
                                            'travel_class'=>session('searchParams.travel_class'),
                                           
                                        ];
                                       
                                    @endphp

                                @include('frontend.flight.partials.search-form',['data'=>$formData])


                            </div>
                           
                        </div>
                    </div><!-- /.rt-banner-searchbox -->


                </div><!-- /.col-lg-10 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </div>
</div><!-- /.rt-bredcump -->







<div class="spacer-bottom"></div><!-- /.spacer-bottom -->
<section class="content-area">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="tab-content" id="rt-BototmTab">
                    <div class="tab-pane show active fade-in-bottom" id="rt-item_b_first" role="tabpanel"
                        aria-labelledby="rt-item_b_first">
                        <div class="row">
                            <div class="col-xl-3 col-lg-4 col-md-6 mx-auto">
                                <div class="rt-sidebar-group">
                                    <div class="rt-widget widget_range-slider">
                                        <h3 class="rt-widget-title">
                                            Filter by Price
                                        </h3><!-- /.rt-widget-title -->

                                        <div class="slider-range"></div>
                                        <div class="price_slider_amount">
                                            <div class="clearfix">
                                                <div class="float-left">
                                                    <span>Price:</span>
                                                </div><!-- /.float-left -->
                                                <div class="float-right">
                                                    <input type="text" class="amount" name="price"
                                                        placeholder="Add Your Price" id="amount"/>
                                                </div><!-- /.float-right -->
                                            </div><!-- /.clearfix -->
                                        </div>

                                         {{-- <div class="js-price-rangeSlider">
                                                <div class="text-14 fw-500 "></div>
                          
                                                <div class="d-flex">
                                                  <div class=" w-100 text-center">
                                                    <span class="js-lower"></span>
                                                    -
                                                    <span class="js-upper"></span>
                                                  </div>
                                                </div>
                          
                                                <div class="px-1">
                                                  <div class="js-slider"></div>
                                                </div>
                                        </div> --}}
                                       
                                    </div><!-- /.rt-widget -->
                                    <div class="rt-widget widget_plane_time">
                                        <h3 class="rt-widget-title">
                                            Stops
                                        </h3><!-- /.rt-widget-title -->
                                        <ul>
                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="stop0" name="stopFilter" value="0">
                                                    <label class="form-check-label" for="stop0">
                                                        Nonstop
                                                    </label>
                                                </div><!-- ./orm-group -->
                                              
                                            </li>
                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="stop1" name="stopFilter" value="1">
                                                    <label class="form-check-label" for="stop1">
                                                        1 Stop 
                                                    </label>
                                                </div><!-- ./orm-group -->
                                                
                                            </li>

                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="stop2" name="stopFilter" value="2">
                                                    <label class="form-check-label" for="stop2">
                                                        2 Stops
                                                    </label>
                                                </div><!-- ./orm-group -->
                                                
                                            </li>

                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="stop3" name="stopFilter" value="3">
                                                    <label class="form-check-label" for="stop3">
                                                        3 Stops 
                                                    </label>
                                                </div><!-- ./orm-group -->
                                                
                                            </li>
                                        </ul>
                                    </div><!-- /.rt-widget -->
                                    <div class="rt-widget widget_plane_time">
                                        <h3 class="rt-widget-title">
                                            Airlines included
                                        </h3><!-- /.rt-widget-title -->
                                        <ul>
                                            @foreach ($data->dictionaries->carriers as $airKey => $airline)
                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="gridCheckrt-{{ $airKey }}" value="{{ $airKey }}" name="airlineFilter">
                                                    <label class="form-check-label" for="gridCheckrt-{{ $airKey }}" >
                                                        {{ $airline }}
                                                    </label>
                                                </div><!-- ./orm-group -->
                                               
                                            </li>
                                            @endforeach
                                            
                                        </ul>
                                     
                                    </div><!-- /.rt-widget -->
                                    <div class="rt-widget widget_plane_time">
                                        <h3 class="rt-widget-title">
                                            Departure time
                                        </h3><!-- /.rt-widget-title -->
                                        <ul>
                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="gridCheckrt-11" value="12am_6am" name="departureTime">
                                                    <label class="form-check-label" for="gridCheckrt-11">
                                                        Late Night To Early Mor (12 am to 6:00 am)
                                                    </label>
                                                </div><!-- ./orm-group -->

                                            </li>
                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="gridCheckrt-111" value="6am_12pm" name="departureTime">
                                                    <label class="form-check-label" for="gridCheckrt-111">
                                                        Mor  (6:00 am to 12 pm)
                                                    </label>
                                                </div><!-- ./orm-group -->

                                            </li>
                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="gridCheckrt-1111" value="12pm_6pm" name="departureTime">
                                                    <label class="form-check-label" for="gridCheckrt-1111">
                                                      After-Noon To Evening (12:00 pm to 6:00 pm)
                                                    </label>
                                                </div><!-- ./orm-group -->

                                            </li>

                                            <li class="clearfix">

                                                <div class="form-check-inline">
                                                    <input class="form-check-input" type="checkbox"
                                                        id="gridCheckrt-1111q" value="after_6pm" name="departureTime">
                                                    <label class="form-check-label" for="gridCheckrt-11111">
                                                      Night (6:00 pm to 12 pm)
                                                    </label>
                                                </div><!-- ./orm-group -->

                                            </li>
                                        </ul>

                                    </div><!-- /.rt-widget -->
                                 
                                </div><!-- /.rt-sidebar-group -->
                            </div><!-- /.col-lg-3 -->
                            <div class="col-xl-9 col-lg-10 mx-auto mt-5 mt-xl-0">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class=" rt-mb-30">
                                            <form action="#" class="row">
                                                <div class="col-lg-3 col-md-6 mb-3 mb-lg-0">
                                                    <button
                                                        class="rt-btn pill rt-sm rt-gradient d-block" type="button"> @if (!empty($data->data))

                                                        {{ count($data->data) .' flights found. '}}
                                                   
                                                        
                                                    @endif</button>
                                                </div><!-- /.col-lg-4 -->
                                                
                                               
                                            </form>
                                        </div><!-- /.flight-list-box -->
                                    </div>

                                    <div class="col-lg-12 col-md-6">

                                        @foreach ($data->data as $mainKey=> $flights)

                                        @php
                                        $seg3 = '';
                                        $seg2 = '';
                                        $iti = '';
                                        $seg4='';
                                        
                                        if (count($flights->itineraries[0]->segments) - 1 == 1) {
                                            // means it has two segments
                                            $seg2 = $flights->itineraries[0]->segments[1]->carrierCode;
                                        }
                                
                                        if (count($flights->itineraries[0]->segments) - 1 == 2) {
                                            // means it has three segments
                                            $seg3 = $flights->itineraries[0]->segments[2]->carrierCode;
                                        }
                                
                                        if (count($flights->itineraries) == 2) {
                                            $iti = $flights->itineraries[1]->segments[0]->carrierCode;
                                            if (count($flights->itineraries[1]->segments) - 1 != 0) {
                                                $seg4 = $flights->itineraries[1]->segments[1]->carrierCode;
                                            }
                                        } else {
                                            $iti = '';
                                        }
                                    @endphp
                
                                        <div class="flight-list-box rt-mb-30 row"  data-stop="{{ count($flights->itineraries[0]->segments)-1 }}" data-price="{{ $flights->price->grandTotal }}"  data-airline1="{{ $flights->itineraries[0]->segments[0]->carrierCode }}" data-airline2="{{ $seg2 }}" data-airline3="{{ $iti }}" data-airline4="{{ $seg3 }}" data-airline5="{{ $seg4 }}" data-departuretime="{{ $flights->itineraries[0]->segments[0]->departure->at }}">

                                            @foreach ($flights->itineraries as $itiKey=> $itineraries)
                                                @php
                                                    $segmentsCount = $itineraries->segments;

                                                    $num_segments = count($segmentsCount);

                                                    $first_segment = $segmentsCount[0];

                                                    $last_segment = $segmentsCount[$num_segments - 1]
                                                @endphp    
                                            <div
                                                class="top-content d-flex flex-lg-row flex-column align-items-lg-center justify-content-left  justify-content-lg-between col-lg-10">

                                                <div class="flight-logo">
                                                    <img src="{{ url('assets/frontend/images/airlines/'.$first_segment->carrierCode) }}.png" alt="flt logo"
                                                        draggable="false">
                                                </div><!-- /.flight-logo -->
                                                <div class="pricing">
                                                    <h5>{{ $data->dictionaries->carriers->{$first_segment->carrierCode} }}
                                                    </h5>
                                                    <p>{{ $first_segment->carrierCode .$first_segment->number }} | {{ $data->dictionaries->aircraft->{$first_segment->aircraft->code} }}</p>
                                                </div><!-- /.pricing -->
                                                <div
                                                    class="flight-time d-flex justify-content-between align-items-lg-center">
                                                    <div class="left">
                                                        <span class="d-block">{{ formatTime($first_segment->departure->at,'h:i a') }}</span>
                                                        <span class="d-block">{{ $first_segment->departure->iataCode }} </span>
                                                    </div><!-- /.left -->
                                                    <div class="middle">
                                                        <img src="{{ asset('assets/frontend/images/all-img/time-shape-line.png') }}"
                                                            alt="time shape" draggable="false">
                                                    </div><!-- /.middle -->
                                                    <div class="right">
                                                        <span class="d-block">{{ formatTime($last_segment->arrival->at,'H:i') }}</span>
                                                        <span class="d-block">{{ $last_segment->arrival->iataCode }}</span>
                                                    </div><!-- /.rght -->
                                                </div><!-- /.flight-time -->
                                                <div class="flight-detils">
                                                    <span class="d-block"><i
                                                            class="icofont-clock-time"></i><!-- /.time -->{{ formatDuration($itineraries->duration) }} </span>
                                                    <span class="d-block">
                                                        <a href="#flightDetailsCollapse-{{ $itiKey.'-'.$flights->id }}"
                                                            class="flt-d-clic" data-toggle="collapse" role="button"
                                                            aria-expanded="false"
                                                            aria-controls="flightDetailsCollapse-{{ $itiKey.'-'.$flights->id }}">Flight details <i
                                                                class="icofont-simple-down"></i></a></span>
                                                </div><!-- /.flight-detils -->
                                               
                                            </div>

                                            <div class="collapse bottom-content mb-5" id="flightDetailsCollapse-{{ $itiKey.'-'.$flights->id }}" style="width:100%">
                                                <p></p>
                                                <ul class="flight-timeline">

                                                    @foreach ($itineraries->segments as $segKey => $segment)
                                                        
                                                    <li>
                                                        <span>{{ formatTime($segment->departure->at,'M-d-Y') }}</span>

                                                    </li>
                                                    <li><span>{{ $segment->departure->iataCode }} - {{ $segment->arrival->iataCode }}</span>
                                                    </li>

                                                    @endforeach

                                                   
                                                </ul>
                                            </div>
                                            
                                            @endforeach
                                            <div class="col-lg-2 col-md-6 col-sm-12">
                                                <div class="trip">
                                                    <span class="d-blok">{{ getCurrencySymbol($flights->price->currency).' '.$flights->price->grandTotal}}</span>
                                                    <span class="d-block">{{ count($flights->itineraries) > 1 ? 'Roundtrip' : 'Singletrip' }}</span>
                                                </div><!-- /.trip -->
                                                <div class="book-now">
                                                    <form action="{{ route('flight-book') }}" method="post">
                                                        @csrf

                                                        <input type="hidden" name="selectedFlightData" value='{{ json_encode($flights) }}'>
                                                        <input type="hidden" name="dictionaries" value='{{ json_encode($data->dictionaries) }}'>

                                                        <button
                                                        class="rt-btn  pill rt-gradient text-uppercase">Book</button>

                                                    </form>
                                                  
                                                </div><!-- /.book-now -->
                                            </div>
                                           
                                            {{-- <div class="collapse bottom-content" id="flightDetailsCollapse-{{ $mainKey }}">
                                                <p><span>Scoot - TR979 | Airbus A320 | Economy</span> <span><i
                                                            class="icofont-clock-time"></i>4h5m</span></p>
                                                <ul class="flight-timeline">

                                                    <li>
                                                        <span>Nov 12 10:55</span>

                                                    </li>
                                                    <li><span>HKG - Hong Kong Hong Kong International Airport T2</span>
                                                    </li>
                                                    <li>
                                                        <span>Nov 12 15:00</span>

                                                    </li>
                                                    <li><span>SIN - Singapore Changi Airport T2</span></li>
                                                </ul>
                                            </div> --}}

                                            {{-- collapse end  --}}

                                        </div>

                                        @endforeach

                                    </div>

                                </div>
                              
                            </div><!-- /.col-lg-9 -->
                        </div><!-- /.row -->
                    </div>
                  
                </div>
            </div><!-- /.col-12 -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</section>

@section('scripts')

{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.4/nouislider.min.js"></script> --}}

{{-- <script src="{{ url('assets/frontend/js/filters.js') }}"></script> --}}

@endsection


@endsection

