<?php

namespace App\Http\Controllers;

use App\Models\LabTest;
use App\Models\TestReport;
use App\Models\TestVeriable;
use App\Models\FinalTestReport;
use Illuminate\Http\Request;



class LabTestController extends Controller
{
    public function index()
    {
        $labtests = LabTest::all();

        return view('backend.labtest.list', compact('labtests'));
    }

    public function create()
    {
        return view('backend.labtest.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'testcode' => 'required|unique:labtests',
            'testname' => 'required',
            'rate' => 'required|numeric',
            'sample' => 'required',
        ]);

        $LabTest = LabTest::create($request->only([
            'testcode',
            'testname',
            'MiniUnit',
            'maxunit',
            'Unit',
            'rate',
            'sample',

        ]));





        // LabTest::create($request->all());

        return redirect()->route('labtest.list')->with('success', 'Lab Test created successfully.');
    }

    public function edit(LabTest $labtest)
    {
        return view('backend.labtest.edit', compact('labtest'));
    }

    public function update(Request $request, LabTest $labtest)
    {
        $request->validate([
            'testcode' => 'required|unique:labtests,testcode,' . $labtest->id,
            'testname' => 'required',
            'rate' => 'required|numeric',
            'sample' => 'required',
        ]);

        $labtest->update($request->all());

        return redirect()->route('labtests.index')->with('success', 'Lab Test updated successfully.');
    }

    public function destroy(LabTest $labtest)
    {
        $labtest->delete();
        return redirect()->route('labtests.index')->with('success', 'Lab Test deleted successfully.');
    }

    public function autocompleteCode(Request $request)
    {
        $term = $request->get('term');

        $tests = LabTest::where('testcode', 'LIKE', "%{$term}%")
            ->get(['testcode', 'testname', 'rate', 'sample']);

        $results = [];

        foreach ($tests as $test) {
            $results[] = [
                'label' => $test->testcode . ' - ' . $test->testname, // optional display
                'value' => $test->testcode,
                'testcode' => $test->testcode,
                'testname' => $test->testname,
                'rate' => $test->rate,
                'sample' => $test->sample
            ];
        }

        return response()->json($results);
    }





    public function results($id)
    {
        // Fetch TestReport with related patient and labtest
        $report = TestReport::with(['patient', 'labtest'])
            ->where('patient_id', $id)
            ->get();



        // return response()->json($report);


        return view('backend.reports.create', compact('report'));
    }

    public function veriables($id)
    {
        // Fetch TestReport with related patient and labtest
        $testveriables = TestVeriable::with(['labtest'])
            ->where('test_id', $id)
            ->get();



        // return response()->json($report);


        return view('backend.labtest.testveriables.list', compact('testveriables','id'));
    }


public function veriablescreate($id)
{
    return view('backend.labtest.testveriables.create', compact('id'));
}


    public function veriableStore(Request $request)
    {

        // print_r($request->all());

        $request->validate([
            'testveriable' => 'required', 
            'unit' => 'nullable',
            'test_id' => 'required|exists:labtests,id',
        ]);

        TestVeriable::create($request->all());

        return redirect()->route('test.veriable.list', $request->test_id)->with('success', 'Lab Test created successfully.');

    }

  public function reportresultCreate($id)
    {

       

         $report = TestVeriable::with([ 'labtest'])
            ->where('test_id', $id)
            ->get();


return view('backend.reports.add', compact('report'));
        // return redirect()->route('test.veriable.list', $request->test_id)->with('success', 'Lab Test created successfully.');

    }



    public function reportstore(Request $request)   
    {
    $results = $request->input('results'); // array of testveriable_id => result



    print_r($results);

//     foreach ($results as $testId => $result) {
//        FinalTestReport::updateOrCreate(
//     ['testveriable_id' => $testId],
//     [
//         'test_result' => $result,
//         'test_id' => $testId, // or the correct test_id from your logic
//     ]
// );
//     }

//     return redirect()->back()->with('success', 'Results submitted successfully!');
    }

}
