<?php

namespace App\Http\Controllers;
use App\Models\LabTest;
use App\Models\TestReport;
use App\Models\Patient;
use Illuminate\Http\Request;
use App\Models\Transaction;

class PatientController extends Controller
{
    public function index()
    {
        $patients = Patient::latest()->paginate(20);
        return view('backend.patients.list', compact('patients'));
    }

    public function create()
    {
        return view('backend.patients.create');
    }

    public function store(Request $request)
    {
       

        $request->validate([
            'patient_name' => 'required',
            'mobile_number' => 'nullable',
        ]);

        // Create patient
    $patient = Patient::create($request->only([
        'mr_no', 'patient_name', 'gender', 'mobile_number', 
        'marital_status', 'relative_name', 'doctor', 
        'sample_location', 'email', 'cnic', 'ipd_location', 
        'age', 'father_or_husband', 'insurance', 'panel', 'address',
        'sample_date'
    ]));
   // Save test reports
    if ($request->has('testcodes')) {
        foreach ($request->testcodes as $key => $code) {
            $labTest = LabTest::where('testcode', $code)->first();

           

            TestReport::create([
                'patient_id' => $patient->id,
                'labtest_id' => $labTest ? $labTest->id : null,
                'report_date' => $request->report_dates[$key],
                'comments' => $request->comments[$key],
            ]);
        }
    }

    // Save transaction
    Transaction::create([
        'patient_id' => $patient->id,
        'total_amount' => $request->total_amount,
        'discount_percent' => $request->discount_percent,
        'discount_amount' => $request->discount_amount,
        'payable_amount' => $request->payable_amount,
        'other_charges' => $request->other_charges,
        'received_amount' => $request->received_amount,
        'balance_amount' => $request->balance_amount,
        'payment_mode' => $request->payment_mode,
    ]);


        return redirect()->route('patients.list')->with('success', 'Patient added successfully.');
    }

    public function edit(Patient $patient)
    {
        return view('backend.patients.edit', compact('patient'));
    }

    public function update(Request $request, Patient $patient)
    {
        $patient->update($request->all());

        return redirect()->route('patients.list')->with('success', 'Patient updated successfully.');
    }

    public function destroy(Patient $patient)
    {
        $patient->delete();

        return redirect()->route('patients.list')->with('success', 'Patient removed successfully.');
    }
}
