<?php

namespace App\Http\Controllers;

use App\Models\Transaction;
use App\Models\LabTest;
use App\Models\Patient;
use Illuminate\Http\Request;

class TransactionController extends Controller
{
    public function index()
    {
        $transactions = Transaction::with('patient', 'labtest')->latest()->paginate(10);
        return view('transactions.index', compact('transactions'));
    }

    public function create()
    {
        $patients = Patient::all();
        $labtests = LabTest::all();

        return view('transactions.create', compact('patients', 'labtests'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'patient_id' => 'required',
            'labtest_id' => 'required',
            'amount' => 'required|numeric',
            'payment_method' => 'required',
        ]);

        Transaction::create([
            'patient_id' => $request->patient_id,
            'labtest_id' => $request->labtest_id,
            'amount' => $request->amount,
            'payment_method' => $request->payment_method,
            'status' => $request->status ?? 'paid',
            'remarks' => $request->remarks,
            'date' => now(),
        ]);

        return redirect()->route('transactions.index')
                         ->with('success', 'Transaction Created Successfully');
    }

    public function edit(Transaction $transaction)
    {
        $patients = Patient::all();
        $labtests = LabTest::all();

        return view('transactions.edit', compact('transaction', 'patients', 'labtests'));
    }

    public function update(Request $request, Transaction $transaction)
    {
        $request->validate([
            'patient_id' => 'required',
            'labtest_id' => 'required',
            'amount' => 'required|numeric',
            'payment_method' => 'required',
        ]);

        $transaction->update($request->all());

        return redirect()->route('transactions.index')
                         ->with('success', 'Transaction Updated Successfully');
    }

    public function destroy(Transaction $transaction)
    {
        $transaction->delete();

        return redirect()->route('transactions.index')
                         ->with('success', 'Transaction Deleted Successfully');
    }
}
