<?php

namespace App\Http\Controllers\payments;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transection;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use App\Models\Withdraw;
use App\Models\Deposit;
use App\Models\UserBalance;

class TransactionsController extends Controller
{
    public function index(){

        $authUser=Auth::user();
        $query=Transection::query()->with('user', 'userBalance','createdBy', 'releted');

        if (!$authUser->hasPermissionTo('manage all transactions')) {
           $query->where('user_id',$authUser->id);
        }
        $transactions=  $query->get();

        return view('backend.payments.transactions.transactions', compact('transactions'));
       
    }
    public function edit($id){
        $transaction=Transection::with('user')->findorfail($id);
        $authUser=Auth::user();
        if (!$authUser->hasPermissionTo('manage all transactions') && $authUser->id!=$transaction->user_id) {
            return redirect()->route('transactions.index')->with('error','You are not authorized to access it');

         }
        return view('backend/payments/transactions/update',compact('transaction'));

    }
    // public function update(Request $request ,$id){
        
    //     return redirect()->back()->with('error','Oops.! This function is currently deactivated.'); // deactivated 
    //     $validatedData =  $request->validate([
    //         'transection_category' => ['sometimes','nullable', 'string', 'max:190'],
    //         'comments' => ['sometimes', 'string', 'nullable'],
    //         'status'=> ['required', Rule::in(['pending', 'completed','canceled'])],
    //     ]);


    //     $transaction = Transection::findOrFail($id);

    //     $transaction->update($validatedData);
    //     return redirect()->route('transactions.index')->with('success','transaction updated successfully');
    // }

    public function destroy($id){
        return redirect()->back()->with('error','Oops.! This function is currently deactivated.');
        $payment=Transection::findOrfail($id);
        $payment->delete();
        return redirect()->route('transactions.index')->with('success','Transaction deleted successfully');
    }


}
