<?php

namespace App\Http\Controllers\properties;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Surrounding;
use App\Models\Cardinformation;
use App\Models\PropertySurrounding;
use App\Models\RoomType;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class CustomerController extends Controller
{
    public function index()
  {
    $user = Auth::user();
    
    // Check if the user has permission to manage all properties
    if ($user->hasPermissionTo('manage all properties')) {
        $Cardinformation = Cardinformation::with(['user'])->get();
    } else {
        $Cardinformation = Cardinformation::where('user_id', $user->id)
            ->with(['user', 'roomTypes'])
            ->get();
    }

    return view('backend/properties/properties', compact('Cardinformation'));
  }

    public function create(){
        $user = Auth::user();

        if ($user->hasPermissionTo('manage all properties') || $user->id) {
            return view('backend/properties/create');
        } else {
            return redirect()->back()->with('error', 'You are not authorized to edit this form.');
        }

       

    }

    public function store(Request $request)
    {

      

        $request->validate([
            'name' => ['required', 'string', 'max:191'],
            'father_name' => ['required', 'string', 'max:191'],
            'cnic' => ['required', 'string', 'max:191'],
            'registrationno' => ['required', 'string', 'max:191'],
            'contact' => ['required', 'numeric', 'min:0'],
            'status' => ['required', 'in:active,inactive'],
        ]);
        
        $Cardinformation = new Cardinformation([
            'name' => $request->input('name'),
            'father_name' => $request->input('father_name'),
            'cnic' => $request->input('cnic'),
            'registrationno' => $request->input('registrationno'),
            'contact' => $request->input('contact'),

            'whatsapp' => $request->input('whatsapp'),
            'address1' => $request->input('address1'),
            'district' => $request->input('district'),
            'tehsil' => $request->input('tehsil'),
            'house_type' => $request->input('house_type'),
            'occupation' => $request->input('occupation'),


            'monthlyincome' => $request->input('monthlyincome'),
            'diseases' => $request->input('diseases'),
            'diseasetimeperiod' => $request->input('diseasetimeperiod'),
      'date' => now()->format('Y-m-d'),
            'fee' => $request->input('fee'),
          

            'Dependant1' => $request->input('Dependant1'),
            'Dependant2' => $request->input('Dependant2'),
            'Dependant3' => $request->input('Dependant3'),
            'Dependant4' => $request->input('Dependant4'),
            'Dependant5' => $request->input('Dependant5'),
            'Dependant6' => $request->input('Dependant6'),
            'Dependant7' => $request->input('Dependant7'),
            'Dependant8' => $request->input('Dependant8'),
            'Dependant9' => $request->input('Dependant9'),
           









            'approvedstatus' => $request->input('status'),
        ]);
        
        $Cardinformation->user_id = auth()->id(); // Assuming you're using authenticated user's ID
    
        if ($request->hasFile('profile_picture')) {
            $file = $request->file('profile_picture');
            $path = 'images/profiles/';  // Folder where you want to store profile pictures
            $fileName = time() . '_' . $file->getClientOriginalName();
        
            // Store the file in the public disk
            $file->storeAs($path, $fileName, 'public');
        
            // Save the file path to the database
            $Cardinformation->profile_picture = $path . $fileName;
           
        }

        $Cardinformation->save();
    
        return redirect()->route('cards.index')->with('success', 'Property created successfully.');
    }

    public function edit($id)
     {
        $response = Cardinformation::with(['user'])->findOrFail($id);

        $user = Auth::user();

        // echo "<pre>";print_r(json_decode($response));exit;

        if ($user->hasPermissionTo('manage all properties') || $response->user_id === $user->id) {
            return view('backend/properties/update', compact('response'));
        } else {
            return redirect()->back()->with('error', 'You are not authorized to edit this property.');
        }

     }


     public function show($id)
     {
        $property = Property::with(['user', 'roomTypes'])->findOrFail($id);

        $user = Auth::user();

        // echo "<pre>";print_r(json_decode($property->amenities));exit;

        if ($user->hasPermissionTo('manage all properties') || $property->user_id === $user->id) {
            return view('backend/properties/update', compact('property'));
        } else {
            return redirect()->back()->with('error', 'You are not authorized to edit this property.');
        }

     }



    public function update(Request $request, $id)
    {
        $property = Property::findOrFail($id);
        
        $user = Auth::user();
        
        if (!($user->hasPermissionTo('manage all properties') || $property->user_id === $user->id)) {
            return redirect()->back()->with('error', 'You are not authorized to update this property.');
        }

        $request->validate([
            'title' => ['required', 'string', 'max:191'],
            'type' => ['required', 'in:hotel,villah,apartment,guest house'],
            'location' => ['required', 'string', 'max:191'],
            'cordinates' => ['required', 'regex:/^-?\d+(\.\d+)?,-?\d+(\.\d+)?$/'],
            'price_per_night' => ['required', 'numeric', 'min:0'],
            'cancellation_charges' => ['required', 'numeric', 'min:0'],
            'payment_allowed' => ['required', 'in:cash,card,both'],
            'check_in_time' => ['required', 'date_format:H:i:s'],
            'check_out_time' => ['required', 'date_format:H:i:s'],
            'status' => ['required', 'in:active,inactive'],
            'description' => ['required', 'string'],
            'images.*' => ['sometimes', 'nullable', 'image', 'mimes:jpeg,jpg,png,gif'],
        ]);

        $property->title = $request->input('title');
        $property->type = $request->input('type');
        $property->location = $request->input('location');
        $property->cordinates = $request->input('cordinates');
        $property->price_per_night = $request->input('price_per_night');
        $property->cancellation_charges = $request->input('cancellation_charges');
        $property->payment_allowed = $request->input('payment_allowed');
        $property->check_in_time = $request->input('check_in_time');
        $property->check_out_time = $request->input('check_out_time');
        $property->status = $request->input('status');
        $property->description = $request->input('description');

        if ($request->hasFile('images')) {
            $images = json_decode($property->images, true) ?? []; // Decode the existing images or initialize as an empty array
            foreach ($request->file('images') as $file) {
                $path = 'images/properties/';
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->storeAs($path, $fileName, 'public');
                $fullFilePath = $path . $fileName;
                $images[] = $fullFilePath;
            }
            $property->images = json_encode($images);
        }

        $property->save();

        return redirect()->route('properties.index')->with('success', 'Property updated successfully.');
    }


     ///////// for deleting property images ///////
     public function deleteImage($propertyId, $index)
     {
       try {
           $property = Property::findOrFail($propertyId);
   
           $images = json_decode($property->images);
   
           // Delete the image file from storage
           Storage::disk('public')->delete($images[$index]);
   
   
           // Remove the image path from the array
           unset($images[$index]);
   
           // Reindex the array if it becomes empty
           if (empty($images)) {
               $property->images = null; // Reset to NULL if no images are left
           } else {
               $property->images = array_values($images); // Reindex the array
           }
           $property->save();
   
           return response()->json(['message' => 'Image deleted successfully','redirect'=>route('properties.edit',$propertyId)], 200);
       } catch (\Exception $e) {
           return response()->json(['message' => 'Image deletion failed'], 500);
       }
     }

     //// update amenieties 

     
   
    
}
