<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TestReport extends Model
{
     use HasFactory;

    protected $fillable = [
         'patient_id',
        'labtest_id',
        'testcode',
        'testname',
        'rate',
        'sample',
        'sample_status',
        'sample_date',
        'reporting_date',
        'result',
        'status',
        'comments'
    ];

    // Correct relationship
    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
        // patient_id is the foreign key in test_reports table
        // id is the primary key in patients table
    }

    public function labtest()
    {
        return $this->belongsTo(LabTest::class, 'labtest_id', 'id');
    }
}