<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
   use HasFactory;

    protected $fillable = [
        'patient_id',
        'total_amount',
        'discount_percent',
        'discount_amount',
        'payable_amount',
        'other_charges',
        'received_amount',
        'balance_amount',
        'payment_mode',
    ];

    /**
     * Relationship with Patient
     */
    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    /**
     * Accessor to check if fully paid
     */
    public function getIsPaidAttribute()
    {
        return $this->balance_amount <= 0;
    }
}
