<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
             $table->string('mr_no')->nullable();                       // M.R.NO.
            $table->string('gender')->nullable();                      // Gender
            $table->string('marital_status')->nullable();              // Marital Status
            $table->string('mobile_number')->nullable();               // Mobile Number
            $table->string('relative_name')->nullable();               // Relative Name
            $table->string('patient_name')->nullable();                // Patient Name
            $table->string('sample_location')->nullable();             // Sample Location
            $table->string('email')->nullable();                       // Email
            $table->string('cnic')->nullable();                        // CNIC
            $table->string('doctor')->nullable();                      // Doctor
            $table->date('sample_date')->nullable();                   // Sample Date
            $table->string('ipd_location')->nullable();                // IPD Location
            $table->string('age')->nullable();                         // Age
            $table->string('father_or_husband')->nullable();           // Father / Husband
            $table->boolean('insurance')->default(false);              // Insurance yes/no
            $table->boolean('panel')->default(false);                  // Panel yes/no
            $table->text('address')->nullable();                       // Address
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patients');
    }
};
