<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

        $table->string('name');
        $table->string('email')->unique()->nullable();
        $table->string('mobile')->nullable();
        $table->string('address')->nullable();
        $table->enum('gender', ['male', 'female', 'other'])->nullable();

        $table->boolean('status')->default(1);
        $table->decimal('commission', 10, 2)->default(0);

       

        $table->timestamp('email_verified_at')->nullable();
        $table->string('password')->nullable();

        $table->rememberToken();
        $table->timestamp('last_reply_seen_at')->nullable();

        $table->boolean('waive_fees')->default(0);

        $table->string('image')->nullable();

        $table->boolean('active_status')->default(0);
        $table->string('avatar')->nullable();
        $table->boolean('dark_mode')->default(0);
        $table->string('messenger_color')->default('#2180f3');

        $table->string('social_id')->nullable();
        $table->string('social_provider')->nullable();
        $table->string('social_token')->nullable();
        $table->string('login_method')->nullable();

        $table->timestamps();

        // Foreign key for referred user
      
           
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
