<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('labtests', function (Blueprint $table) {
            $table->id();

            $table->string('testcode')->unique();
            $table->string('testname');
            $table->string('MiniUnit');
            $table->string('maxunit');
            $table->string('Unit');
            $table->decimal('rate', 10, 2)->default(0);
            $table->string('sample')->nullable();
            $table->string('reporting_date')->nullable();   // or use ->date() if needed
            $table->string('sample_status')->nullable();
            $table->text('comments')->nullable();

            $table->timestamps();
        });
    }



    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('labtests');
    }
};
