<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_reports', function (Blueprint $table) {
          $table->id();
        // Relationship with patient or customer
        $table->unsignedBigInteger('patient_id')->nullable();
        // Relationship with lab test
        $table->unsignedBigInteger('labtest_id')->nullable();
        // Result fields
        $table->text('result')->nullable();
        $table->string('status')->default('pending'); // pending / completed / delivered
        $table->text('comments')->nullable();
        $table->timestamps();
        // Foreign Keys
        $table->foreign('patient_id')->references('id')->on('patients')->onDelete('set null');
        $table->foreign('labtest_id')->references('id')->on('labtests')->onDelete('set null');
    });
}



 

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_reports');
    }
};
