<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testveriables', function (Blueprint $table) {
            $table->id();
            $table->string('testveriable');
            $table->string('reference_mini_range')->nullable();
            $table->string('reference_max_range')->nullable();
            $table->string('unit')->nullable();
            $table->unsignedBigInteger('test_id'); // Foreign key
            
            // If you want foreign key constraint
            $table->foreign('test_id')
                  ->references('id')->on('labtests') // change table name if needed
                  ->onDelete('cascade');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('testveriables');
    }
};
