<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('final_test_reports', function (Blueprint $table) {
           $table->id();

            // Foreign key to testveriables table
            $table->foreignId('testveriable_id')
                  ->constrained('testveriables')
                  ->onDelete('cascade');

            // Foreign key to tests table (example table name: tests)
            $table->foreignId('test_id')
                  ->constrained('labtests') // name of the table that holds test details
                  ->onDelete('cascade');

            $table->decimal('test_result', 8, 2)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('final_test_reports');
    }
};