document.addEventListener('DOMContentLoaded', function() {

    // Get checkbox elements
    const airlineCheckboxes = document.querySelectorAll('input[name="airlineFilter"]');
    const stopCheckboxes = document.querySelectorAll('input[name="stopFilter"]');
    const depTimeCheckboxes = document.querySelectorAll('input[name="departureTime"]');
    // Get price range slider elements
    // const priceRangeSlider = document.querySelector('.js-price-rangeSlider');
    // const slider = priceRangeSlider.querySelector('.js-slider');
    // const lowerValueElement = priceRangeSlider.querySelector('.js-lower');
    // const upperValueElement = priceRangeSlider.querySelector('.js-upper');

    // Set initial values for price range slider
    let minPrice = Infinity;
    let maxPrice = -Infinity;

    const flightElements = document.querySelectorAll('.flight-list-box');
    flightElements.forEach(function(flightElement) {
        const price = parseFloat(flightElement.dataset.price);

        if (!isNaN(price)) { // Check if price is a valid number
        
            minPrice = Math.min(minPrice, price);
            maxPrice = Math.max(maxPrice, price);
        } else {
           
        }
    });

   
    // Check if minPrice and maxPrice are valid numbers
    if (!isFinite(minPrice) || !isFinite(maxPrice)) {
        // Handle error if prices are not valid
       
    }else{
        // noUiSlider.create(slider, {
        //     start: [minPrice, maxPrice],
        //     step: 0,
        //     connect: true,
        //     range: {
        //         'min': minPrice,
        //         'max': maxPrice
        //     },
        //     format: {
        //         to: function(value) {
        //             return Math.round( value.toString());
        //         },
        //         from: function(value) {
        //             return parseInt(value);
        //         }
        //     }
        // });

        $(".slider-range").slider({
            range: true,
            min: minPrice,
            max: maxPrice,
            values: [minPrice, maxPrice],
            slide: function(event, ui) {
                $("#amount").val(ui.values[0] + " - " + ui.values[1]);
                applyFilters();
            }
        });
        
        // Update prices initially
        $("#amount").val(minPrice + " - " + maxPrice);
        
    }
    
    // Update price range slider values
    // slider.noUiSlider.on('update', function(values, handle) {
    //     if (handle === 0) {
    //         lowerValueElement.innerHTML = Math.round(values[handle]);
    //     } else {
    //         upperValueElement.innerHTML = Math.round(values[handle]);
    //     }
        
    //     // Call the filter function to update flight visibility based on price range
    //     applyFilters();
    // });

    // Handle checkbox change event
    function handleCheckboxChange() {
        // Call the filter function to update flight visibility based on checkboxes
        applyFilters();
    }

    // Attach event listeners to checkboxes
    airlineCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', handleCheckboxChange);
    });

    stopCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', handleCheckboxChange);
    });

    depTimeCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', handleCheckboxChange);
    });

    // Helper function to get checked checkbox values
    function getCheckedValues(checkboxes) {
        const values = [];
        checkboxes.forEach(function(checkbox) {
            if (checkbox.checked) {
                values.push(checkbox.value);
            }
        });
        return values;
    }

    // Filter flights based on selected filters
    function applyFilters() {
        const airlineFilters = getCheckedValues(airlineCheckboxes);

        const depTimeFilter = getCheckedValues(depTimeCheckboxes); // Get selected time filters
        const stopFilters = getCheckedValues(stopCheckboxes);
        // const minPrice = parseInt(slider.noUiSlider.get()[0]);
        // const maxPrice = parseInt(slider.noUiSlider.get()[1]);
    
        const minPrice = $(".slider-range").slider("values", 0);
        const maxPrice = $(".slider-range").slider("values", 1);
        
        // Iterate over flight elements and apply filters
        flightElements.forEach(function(flightElement) {
            const flightStop = flightElement.dataset.stop;
            const price = parseInt(flightElement.dataset.price);

            const departureTime = new Date(flightElement.dataset.departuretime); // Parse departure time
            const departureHourUTC = departureTime.getHours(); // Get UTC hour
    
            // Check if flight matches the selected filters and price range
            const airlineMatch = (airlineFilters.length === 0 ||
                ['data-airline1', 'data-airline2', 'data-airline3', 'data-airline4', 'data-airline5'].some(attribute => {
                    const attributeValue = flightElement.getAttribute(attribute);
                    return attributeValue && airlineFilters.includes(attributeValue);
                }));
            const stopMatch = (stopFilters.length === 0 || stopFilters.includes(flightStop));
            const priceMatch = (price >= minPrice && price <= maxPrice);

            // Assuming the time filter is in local time
            const timeMatch = (depTimeFilter.length === 0 || depTimeFilter.some(timeFilter => {
                switch (timeFilter) {
                    case '12am_6am':
                        return departureHourUTC  >= 0 && departureHourUTC  < 6;
                    case '6am_12pm':
                        return departureHourUTC  >= 6 && departureHourUTC   < 12;
                    case '12pm_6pm':
                        return departureHourUTC  >= 12 && departureHourUTC  < 18;
                    case 'after_6pm':
                        return departureHourUTC  >= 18 && departureHourUTC  <= 23;
                    default:
                        return false;
                }
            }));
    
            // Show or hide the flight element based on all filters

            if (airlineMatch && stopMatch && priceMatch && timeMatch) {
                flightElement.classList.remove('d-none'); // Remove the 'd-none' class to display
            } else {
                flightElement.classList.add('d-none'); // Add the 'd-none' class to hide
            }
        });
    }
    
    
    
    
});