@extends('backend.layouts.main')
@section('title', 'Create New Customer')

@section('main-container')
    <div class="pcoded-content">
        <div class="pcoded-inner-content">
            <!-- Main-body start -->
            <div class="main-body">
                <div class="page-wrapper">
                    <!-- Page-header start -->
                    <div class="page-header">
                        <div class="row align-items-end">
                            <div class="col-lg-8">
                                <div class="page-header-title">
                                    <div class="d-inline">
                                        <h4>Create Test Definition </h4>
                                        <span>You can create Test Definition from here</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="page-header-breadcrumb">
                                    <ul class="breadcrumb-title">
                                        <li class="breadcrumb-item">
                                            <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                        </li>
                                        <li class="breadcrumb-item"><a href="#">Test Definition</a>
                                        </li>
                                        <li class="breadcrumb-item"><a href="">Create</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Page-header end -->


                    <!-- Page body start -->
                    <div class="page-body">
                        @if(session()->has('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if(session()->has('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-sm-12">
                                <!-- Product edit card start -->
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Test Information</h5>
                                    </div>
                                    <div class="card-block">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="product-edit">

                                                    <!-- Tab panes -->
                                                    <div class="tab-content">
                                                        <div class="tab-pane active" id="home7" role="tabpanel">

                                                            <form action="{{route('test.store')}}" method="post"
                                                                enctype="multipart/form-data">
                                                                @csrf

                                                                <!-- Image upload card start -->

                                                                <!-- Image upload card end -->

                                                                <div class="row mt-2">

















                                                                    <div class="col-sm-8">
                                                                        <div class="row">
                                                                            <div class="col-sm-4">
                                                                                <label for="">Test Code</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Test Code"
                                                                                        name="testcode"
                                                                                        value="{{old('testcode')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('testcode')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                           

                                                                            <div class="col-sm-8">
 <label for="">Test Name</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-mobile-phone"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="e.g.cbc"
                                                                                        name="testname"
                                                                                        value="{{old('testname')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('testname')"
                                                                                    class="mt-2" />

                                                                            </div>

                                                                            <div class="col-sm-8">
 <label for="">Test Sample Description</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Test Sample Description"
                                                                                        name="sample"
                                                                                        value="{{old('sample')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('sample')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">
 <label for="">Charges / Fee</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="e.g.600"
                                                                                        name="rate"
                                                                                        value="{{old('rate')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('rate')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">
 <label for="">Minimum Unit Range</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="e.g.10"
                                                                                        name="MiniUnit"
                                                                                        value="{{old('MiniUnit')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('MiniUnit')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">
 <label for="">Maximum Unit Range</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="e.g.20"
                                                                                        name="maxunit"
                                                                                        value="{{old('maxunit')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('maxunit')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">
 <label for="">Unit</label>
                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="e.g. mg/dL"
                                                                                        name="Unit"
                                                                                        value="{{old('Unit')}}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('Unit')"
                                                                                    class="mt-2" />

                                                                            </div>

                                                                       



                                                                        </div>
                                                                    </div>


                                                                    <div class="col-sm-4">
                                                                        <div class="row">

                                                                            <div class="col-sm-12">



                                                                                <div class="card">

                                                                                    <div class="card-header">
                                                                                        <h5>Banner</h5>

                                                                                    </div>
                                                                                    <div class="card-block">
                                                                                      
                                                                                    </div>
                                                                                </div>


                                                                            </div>

                                                                        </div>
                                                                    </div>

















                                                                </div>

                                                                <div class="row">
                                                                    <div class="col-sm-12">
                                                                        <div class="text-center m-t-20">
                                                                            <button type="submit"
                                                                                class="btn btn-primary waves-effect waves-light m-r-10 btn-spinner">Save
                                                                            </button>
                                                                            <a href="{{route('test.list')}}"
                                                                                class="btn btn-warning waves-effect waves-light btn-spinner">Discard
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Product edit card end -->
                            </div>
                        </div>
                    </div>
                    <!-- Page body end -->
                </div>
            </div>
            <!-- Main-body end -->
            <div id="styleSelector">

            </div>
        </div>
    </div>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#db_user_image_upload').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection