@extends('backend.layouts.main')
@section('title', 'Patient')

@section('main-container')
  
  
<div class="pcoded-content">
  <div class="pcoded-inner-content">
      <!-- Main-body start -->
      <div class="main-body">
          <div class="page-wrapper">
              <!-- Page-header start -->
              <div class="page-header">
                  <div class="row align-items-end">
                      <div class="col-lg-8">
                          <div class="page-header-title">
                              <div class="d-inline">
                                  <h4>Test management</h4>
                                  <span>List of all Tests</span>
                              </div>
                          </div>
                         
                      </div>
                      <div class="col-lg-4">
                          <div class="page-header-breadcrumb">
                              <ul class="breadcrumb-title">
                                  <li class="breadcrumb-item">
                                      <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="#!">Customers</a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="">All</a>
                                  </li>
                              </ul>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Page-header end -->
                  
                  <div class="page-body">
                    @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif
                    @if(session()->has('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                    @endif
                    <div class="card">
                      <div class="card-header">
                          <h5 class="card-header-text">Customers</h5>
                          <a href="{{route('test.create')}}" class="btn btn-primary adn-50 adn-right float-right">
                            <i class="icofont icofont-plus"></i>Create New  
                          </a>
                      </div>
                      <div class="card-block contact-details">
                          <div class="data_table_main table-responsive dt-responsive">
                              <table id="simpletable" class="table  table-striped table-bordered nowrap">
                                  <thead>
                                      <tr>
                                          <th>No.</th>
                                          <th>Test Code</th>
                                          <th>Test Name</th>
                                          <th>Rate</th>
                                          <th>Sample</th>
                                          
                                         
                                           
                                         
                                          <th>Action</th>
                                      </tr>
                                  </thead>
                                  <tbody>

                                 
                                    @foreach ($labtests as $key=> $value)
                                        
                                      <tr>
                                          <td>{{$value->id}}</td>
                                        
                                          
                                          <td>{{$value->testcode}}</td>
                                          <td>{{$value->testname}}</td>
                                          <td>{{$value->rate}}</td>
                                          <td>{{$value->sample}}</td>
                                         
                                         <td>
                                            
                                            <a class="btn btn-primary" href="{{ route('test.veriable.list', $value->id) }}">
    <i class="fa fa-eye"></i> Add Perametrs
</a>
                                         </td>

                                      </tr>
                                    @endforeach



                                  </tbody>

                              </table>
                          </div>
                      </div>
                  </div>

                  </div>
              </div>
          </div>
          <!-- Warning Section Starts -->
         
      </div>
  </div> 


  @endsection
