@extends('backend.layouts.main')
@section('title', 'Create New Customer')

@section('main-container')
<div class="pcoded-content">
    <div class="pcoded-inner-content">
        <div class="main-body">
            <div class="page-wrapper">
                <!-- Page-header start -->
                <div class="page-header">
                    <div class="row align-items-end">
                        <div class="col-lg-8">
                            <div class="page-header-title">
                                <div class="d-inline">
                                    <h4>Create Customer</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="page-header-breadcrumb">
                                <ul class="breadcrumb-title">
                                    <li class="breadcrumb-item">
                                        <a href="{{ route('dashboard') }}"><i class="feather icon-home"></i></a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="#">Customer</a></li>
                                    <li class="breadcrumb-item"><a href="">Create</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Page-header end -->

                <!-- Page body start -->
                <div class="page-body">
                    @if(session()->has('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if(session()->has('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-block">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="product-edit">
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="home7" role="tabpanel">
                                                        <form action="{{ route('patients.store') }}" method="post" enctype="multipart/form-data">
                                                            @csrf
                                                            <div class="row mt-2">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
<?php  

$code = rand(100000, 999999);

?>

                                                                            <label for="">M.R.NO.</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <input type="text" class="form-control" placeholder="M.R.NO." name="mr_no" value="{{ old('mr_no', $code) }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('mr_no')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Gender</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-home"></i></span>
                                                                                <select name="gender" class="form-control form-control-primary">
                                                                                    <option value="Male">Male</option>
                                                                                    <option value="Female">Female</option>
                                                                                </select>
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('gender')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Marital Status</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <select name="marital_status" class="form-control form-control-primary">
                                                                                    <option value="married">Married</option>
                                                                                    <option value="single">Single</option>
                                                                                </select>
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('marital_status')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Mobile Number</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-mobile-phone"></i></span>
                                                                                <input type="text" class="form-control" placeholder="e.g.03014865779" name="mobile_number" value="{{ old('mobile_number') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('mobile_number')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Relative</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <input type="text" class="form-control" placeholder="Relative Name" name="relative_name" value="{{ old('relative_name') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('relative_name')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Patient Name</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <input type="text" class="form-control" placeholder="Patient Name" name="patient_name" value="{{ old('patient_name') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('patient_name')" class="mt-2" />
                                                                        </div>

                                                                     

                                                                        <div class="col-sm-2">
                                                                            <label for="">Email</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-email"></i></span>
                                                                                <input type="text" class="form-control" placeholder="Email" name="email" value="{{ old('email') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">C.N.I.C</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="fa-solid fa-id-card"></i></span>
                                                                                <input type="text" class="form-control" placeholder="N.I.C" name="cnic" value="{{ old('cnic') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('cnic')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Doctor</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <input type="text" class="form-control" placeholder="Doctor" name="doctor" value="{{ old('doctor') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('doctor')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Sample Date</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="fa fa-calendar-check-o"></i></span>
                                                                                <input type="datetime-local" class="form-control" name="sample_date" id="report_date" value="{{ old('sample_date') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('sample_date')" class="mt-2" />
                                                                        </div>

                                                                        

                                                                        <div class="col-sm-2">
                                                                            <label for="">Age</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <input type="text" class="form-control" placeholder="Age" name="age" value="{{ old('age') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('age')" class="mt-2" />
                                                                        </div>

                                                                        <div class="col-sm-2">
                                                                            <label for="">Father / Husband</label>
                                                                            <div class="input-group">
                                                                                <span class="input-group-addon"><i class="icofont icofont-ui-user"></i></span>
                                                                                <input type="text" class="form-control" placeholder="Father / Husband" name="father_or_husband" value="{{ old('father_or_husband') }}">
                                                                            </div>
                                                                            <x-input-error :messages="$errors->get('father_or_husband')" class="mt-2" />
                                                                        </div>

                                                                       

                                                                      

                                                                        <div class="col-sm-4">
                                                                            <label for="">Address</label>
                                                                            <textarea rows="1" cols="5" class="form-control" placeholder="Address" name="address">{{ old('address') }}</textarea>
                                                                            <x-input-error :messages="$errors->get('address')" class="mt-2" />
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <!-- Test section -->
                                                                <div class="col-sm-12 mt-3">
                                                                    <div class="row shadow p-3 bg-white rounded">
                                                                        <div class="col-sm-1">
                                                                            <label>Test Code</label>
                                                                            <input type="text" class="form-control" id="testcode" name="testcode">
                                                                        </div>
                                                                        <div class="col-sm-2">
                                                                            <label>Test Name</label>
                                                                            <input type="text" class="form-control" id="testname" name="testname">
                                                                        </div>
                                                                      <div class="col-sm-2">
    <label>Report Date</label>
    <input 
        type="datetime-local" 
        class="form-control" 
        id="report_date" 
        name="report_date" 
        value="{{ now()->format('Y-m-d\TH:i') }}" 
        min="{{ now()->format('Y-m-d\TH:i') }}"
    >
</div>

                                                                        <div class="col-sm-1">
                                                                            <label>Sample</label>
                                                                            <input type="text" class="form-control" id="sample" name="sample">
                                                                        </div>
                                                                        <div class="col-sm-1">
                                                                            <label>Rate</label>
                                                                            <input type="text" class="form-control" id="rate" name="rate">
                                                                        </div>
                                                                        <div class="col-sm-2">
                                                                            <label>Sample Status</label>
                                                                            <select id="sample_status" class="form-control">
                                                                                <option value="Received">Received</option>
                                                                                <option value="Pending">Pending</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-sm-2">
                                                                            <label>Comments</label>
                                                                            <input type="text" class="form-control" id="comments" name="comments">
                                                                        </div>
                                                                        <div class="col-sm-1">
                                                                            <label>&nbsp;</label>
                                                                            <button type="button" id="addTest" class="btn btn-primary btn-block mt-1">ADD</button>
                                                                        </div>
                                                                    </div>

                                                                    <table class="table table-striped table-bordered mt-2">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>#</th>
                                                                                <th>Code</th>
                                                                                <th>Test Name</th>
                                                                                <th>Rate</th>
                                                                                <th>Reporting Date</th>
                                                                                <th>Sample</th>
                                                                                <th>Sample Status</th>
                                                                                <th>Comments</th>
                                                                                <th>Action</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody id="testTableBody"></tbody>
                                                                    </table>
                                                                </div>

                                                                <!-- Payment Section -->
                                                                <div class="col-sm-12 mt-3">
                                                                    <div class="row shadow p-3 bg-white rounded">
                                                                        <div class="col-sm-1"><label>Total Amount</label><input type="text" class="form-control" id="total_amount" name="total_amount" readonly></div>
                                                                        <div class="col-sm-1"><label>Discount %</label><input type="text" class="form-control" id="discount_percent" name="discount_percent" value="0"></div>
                                                                        <div class="col-sm-1"><label>Discount Amount</label><input type="text" class="form-control" id="discount_amount" name="discount_amount" readonly></div>
                                                                        <div class="col-sm-1"><label>Payable Amount</label><input type="text" class="form-control" id="payable_amount" name="payable_amount" readonly></div>
                                                                        <div class="col-sm-1"><label>Other Charges</label><input type="text" class="form-control" id="other_charges" name="other_charges" value="0"></div>
                                                                        <div class="col-sm-1"><label>Received Amount</label><input type="text" class="form-control" id="received_amount" name="received_amount" value="0"></div>
                                                                        <div class="col-sm-1"><label>Payment Mode</label>
                                                                            <select class="form-control" id="payment_mode" name="payment_mode">
                                                                                <option value="cash">Cash</option>
                                                                                <option value="card">Card</option>
                                                                                <option value="online">Online</option>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-sm-1"><label>Balance Amount</label><input type="text" class="form-control" id="balance_amount" name="balance_amount" readonly></div>
                                                                    </div>
                                                                </div>

                                                                <div class="row mt-3 ml-2">
                                                                    <div class="col-sm-12 text-center">
                                                                        <button type="submit" class="btn btn-primary waves-effect waves-light m-r-10">Save</button>
                                                                        <a href="{{ route('patients.list') }}" class="btn btn-warning waves-effect waves-light">Discard</a>
                                                                    </div>
                                                                </div>

                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Page body end -->
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const reportDate = document.getElementById('report_date');
    const now = new Date();

    // Format date as YYYY-MM-DDTHH:MM
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');

    const formatted = `${year}-${month}-${day}T${hours}:${minutes}`;
    reportDate.value = formatted;
    reportDate.min = formatted; // Optional: prevent selecting past date
});


$(document).ready(function() {

    function calculateTotals() {
        let total = 0;
        $("#testTableBody tr").each(function() {
            let rate = parseFloat($(this).find("td:eq(3)").text()) || 0;
            total += rate;
        });
        $("#total_amount").val(total.toFixed(2));

        let discountPercent = parseFloat($("#discount_percent").val()) || 0;
        let discountAmount = total * discountPercent / 100;
        $("#discount_amount").val(discountAmount.toFixed(2));

        let otherCharges = parseFloat($("#other_charges").val()) || 0;
        let payable = total - discountAmount + otherCharges;
        $("#payable_amount").val(payable.toFixed(2));

        let received = parseFloat($("#received_amount").val()) || 0;
        let balance = payable - received;
        $("#balance_amount").val(balance.toFixed(2));
    }

    $("#discount_percent, #other_charges, #received_amount").on('input', calculateTotals);

    let count = 1;
    $("#addTest").click(function () {
        let code = $("#testcode").val();
        let name = $("#testname").val();
        let rate = $("#rate").val();
        let report_date = $("#report_date").val();
        let sample = $("#sample").val();
        let status = $("#sample_status").val();
        let comments = $("#comments").val();

        if(code === "" || name === "") {
            alert("Please select a valid test!");
            return;
        }


 // Get the value from the input
    let rawDate = $("#report_date").val(); // e.g., "2025-11-28T05:43"
    let formattedDate = "";
    if(rawDate){
        let dateObj = new Date(rawDate);
        // Format: DD-MM-YYYY HH:MM AM/PM
        let day = String(dateObj.getDate()).padStart(2,'0');
        let month = String(dateObj.getMonth()+1).padStart(2,'0');
        let year = dateObj.getFullYear();
        let hours = dateObj.getHours();
        let minutes = String(dateObj.getMinutes()).padStart(2,'0');
        let ampm = hours >= 12 ? 'PM' : 'AM';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        hours = String(hours).padStart(2,'0');
        formattedDate = `${day}-${month}-${year} ${hours}:${minutes} ${ampm}`;
    }


        let row = `<tr>
    <td>${count}</td>
    <td>
        ${code}
        <input type="hidden" name="testcodes[]" value="${code}">
    </td>
    <td>
        ${name}
        <input type="hidden" name="testnames[]" value="${name}">
    </td>
    <td>
        ${rate}
        <input type="hidden" name="rates[]" value="${rate}">
    </td>
    <td>
        ${report_date}
        <input type="hidden" name="report_dates[]" value="${report_date}">
    </td>
    <td>
        ${sample}
        <input type="hidden" name="samples[]" value="${sample}">
    </td>
    <td>
        ${status}
        <input type="hidden" name="sample_statuses[]" value="${status}">
    </td>
    <td>
        ${comments}
        <input type="hidden" name="comments[]" value="${comments}">
    </td>
    <td><button type="button" class="btn btn-danger btn-sm removeRow">X</button></td>
</tr>`;

        $("#testTableBody").append(row);
        count++;

        $("#testcode, #testname, #rate, #sample, #comments").val('');
        calculateTotals();
    });

    $(document).on('click', '.removeRow', function() {
        $(this).closest('tr').remove();
        calculateTotals();
    });

    // Autocomplete Test Code
    $("#testcode").autocomplete({
        source: "{{ route('autocomplete.code') }}",
        minLength: 1,
        select: function(event, ui) {
            $("#testcode").val(ui.item.testcode);
            $("#testname").val(ui.item.testname);
            $("#rate").val(ui.item.rate);
            $("#sample").val(ui.item.sample);
        }
    });
});
</script>
@endsection
