@extends('backend.layouts.main')
@section('title', 'Patient')

@section('main-container')
  
  
<div class="pcoded-content">
  <div class="pcoded-inner-content">
      <!-- Main-body start -->
      <div class="main-body">
          <div class="page-wrapper">
              <!-- Page-header start -->
              <div class="page-header">
                  <div class="row align-items-end">
                      <div class="col-lg-8">
                          <div class="page-header-title">
                              <div class="d-inline">
                                  <h4>All Customers</h4>
                                  <span>List of all Customers</span>
                              </div>
                          </div>
                         
                      </div>
                      <div class="col-lg-4">
                          <div class="page-header-breadcrumb">
                              <ul class="breadcrumb-title">
                                  <li class="breadcrumb-item">
                                      <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="#!">Customers</a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="">All</a>
                                  </li>
                              </ul>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Page-header end -->
                  
                  <div class="page-body">
                    @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif
                    @if(session()->has('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                    @endif
                    <div class="card">
                      <div class="card-header">
                          <h5 class="card-header-text">Customers</h5>
                          <a href="{{route('patients.create')}}" class="btn btn-primary adn-50 adn-right float-right">
                            <i class="icofont icofont-plus"></i>Create New  
                          </a>
                      </div>
                      <div class="card-block contact-details">
                          <div class="data_table_main table-responsive dt-responsive">
                              <table id="simpletable" class="table  table-striped table-bordered nowrap">
                                  <thead>
                                      <tr>
                                          <th>No.</th>
                                          <th>Name</th>
                                          <th>Father's / Husband</th>
                                          <th>Contact</th>
                                          <th>CNIC</th>
                                           <th>Status</th>
                                          <th>Created at</th>
                                          <th>Action</th>
                                      </tr>
                                  </thead>
                                  <tbody>

                                    @foreach ($patients as $key=> $value)
                                        
                                      <tr>
                                          <td>{{$key+1}}</td>
                                        
                                          
                                          <td>{{$value->patient_name}}</td>
                                          <td>{{$value->father_or_husband}}</td>
                                          <td>{{$value->mobile_number}}</td>
                                          <td>{{$value->cnic}}</td>
                                            <td>
                                                <span class="badge badge-{{$value->status=='active' ? 'success' : 'danger'}} badge-pill">{{$value->status}}</span>
                                                </td>
                                            <td>{{date('M,d-Y h:i a',strtotime($value->created_at) )}}</td>
                                          <td class="dropdown">
                                              <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-cog" aria-hidden="true"></i></button>
                                              <div class="dropdown-menu dropdown-menu-right b-none contact-menu">
                                              <a class="dropdown-item" href="{{ route('patients.edit', $value->id) }}">
    <i class="icofont icofont-edit"></i> Edit
</a>

<a class="dropdown-item" href="{{ route('patients.show', $value->id) }}">
    <i class="fa fa-eye"></i> View
</a>
<a class="dropdown-item" href="{{ route('test.result', $value->id) }}">
    <i class="fa fa-eye"></i> Add Test Results
</a>

                                              </div>
                                          </td>
                                      </tr>
                                    @endforeach



                                  </tbody>

                              </table>
                          </div>
                      </div>
                  </div>

                  </div>
              </div>
          </div>
          <!-- Warning Section Starts -->
         
      </div>
  </div> 


  @endsection
