@extends('backend.layouts.main')
@section('title', 'Create New Customer')

@section('main-container')
    <div class="pcoded-content">
        <div class="pcoded-inner-content">
            <!-- Main-body start -->
            <div class="main-body">
                <div class="page-wrapper">
                    <!-- Page-header start -->
                    <div class="page-header">
                        <div class="row align-items-end">
                            <div class="col-lg-8">
                                <div class="page-header-title">
                                    <div class="d-inline">
                                        <h4>Create Customer </h4>
                                        <span>You can create Customer from here</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="page-header-breadcrumb">
                                    <ul class="breadcrumb-title">
                                        <li class="breadcrumb-item">
                                            <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                        </li>
                                        <li class="breadcrumb-item"><a href="#">Customer</a>
                                        </li>
                                        <li class="breadcrumb-item"><a href="">Create</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Page-header end -->


                    <!-- Page body start -->
                    <div class="page-body">
                        @if(session()->has('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if(session()->has('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-sm-12">
                                <!-- Product edit card start -->
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Guardians Information</h5>
                                    </div>
                                    <div class="card-block">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="product-edit">

                                                    <!-- Tab panes -->
                                                    <div class="tab-content">
                                                        <div class="tab-pane active" id="home7" role="tabpanel">

                                                            <form action="{{route('cards.store')}}" method="post"
                                                                enctype="multipart/form-data">
                                                                @csrf

                                                                <!-- Image upload card start -->

                                                                <!-- Image upload card end -->

                                                                <div class="row mt-2">
                                                                    <div class="col-sm-4">
                                                                        <label for="">Person Name</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-ui-user"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="Person Name" name="name"
                                                                                value="{{ old('name', $response->name) }}">
                                                                        </div>
                                                                        <x-input-error :messages="$errors->get('name')"
                                                                            class="mt-2" />

                                                                    </div>

                                                                    <div class="col-sm-4">
                                                                        <label for="">Father's / Husband Name</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-ui-user"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="Father's Name" name="Father"
                                                                                value="{{ old('name', $response->father_name) }}">
                                                                        </div>
                                                                        <x-input-error :messages="$errors->get('Father')"
                                                                            class="mt-2" />

                                                                    </div>

                                                                    <div class="col-sm-2">
                                                                        <label for="">National ID card</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-id-card"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="National ID card"
                                                                                name="Nationalid"
                                                                                value="{{ old('name', $response->cnic) }}">
                                                                        </div>
                                                                        <x-input-error
                                                                            :messages="$errors->get('Nationalid')"
                                                                            class="mt-2" />

                                                                    </div>




                                                                    <div class="col-sm-2">
                                                                        <label for="">Registration No</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-numbered"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="No.123456" name="Registration"
                                                                                value="{{ old('name', $response->registrationno ) }}">
                                                                        </div>
                                                                        <x-input-error
                                                                            :messages="$errors->get('Registration')"
                                                                            class="mt-2" />

                                                                    </div>




                                                                    <div class="col-sm-4">
                                                                        <label for="">Mobile Number</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-mobile-phone"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="e.g. 03014865779" name="Mobile"
                                                                                value="{{ old('name', $response->contact) }}">
                                                                        </div>
                                                                        <x-input-error :messages="$errors->get('Mobile')"
                                                                            class="mt-2" />

                                                                    </div>

                                                                    <div class="col-sm-4">
                                                                        <label for="">Whatsapp</label>
                                                                        <div class="input-group">

                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-social-whatsapp"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="e.g. 03014865779"
                                                                                name="Whatsapp"
                                                                                value="{{ old('name', $response->whatsapp) }}">
                                                                        </div>
                                                                        <x-input-error :messages="$errors->get('Whatsapp')"
                                                                            class="mt-2" />

                                                                    </div>



                                                                    <div class="col-sm-2">
                                                                        <label for="">District</label>
                                                                        <select name="type"
                                                                            class="form-control form-control-primary">

                                                                            <option value="hotel">Hotel</option>
                                                                            <option value="villa">Villa</option>
                                                                            <option value="apartment">Apartment</option>
                                                                            <option value="guest house">Guest House</option>

                                                                        </select>
                                                                        <x-input-error :messages="$errors->get('type')"
                                                                            class="mt-2" />
                                                                    </div>


                                                                    <div class="col-sm-2">
                                                                        <label for="">Tehsil</label>
                                                                        <select name="type"
                                                                            class="form-control form-control-primary">

                                                                            <option value="hotel">Hotel</option>
                                                                            <option value="villa">Villa</option>
                                                                            <option value="apartment">Apartment</option>
                                                                            <option value="guest house">Guest House</option>

                                                                        </select>
                                                                        <x-input-error :messages="$errors->get('type')"
                                                                            class="mt-2" />
                                                                    </div>




                                                                    <div class="col-sm-12">
                                                                        <label for="">Address</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="fa fa-map-marker"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="Address" name="Address"
                                                                                value="{{ old('name', $response->address1) }}">
                                                                        </div>
                                                                        <x-input-error :messages="$errors->get('Address')"
                                                                            class="mt-2" />

                                                                    </div>

                                                                    <div class="col-sm-8">
                                                                        <div class="row">
                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant1) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant2) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>

                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant3) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>


                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant4) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>

                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant5) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant6) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant7) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant8) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>
                                                                            <div class="col-sm-4">

                                                                                <div class="input-group">
                                                                                    <span class="input-group-addon"><i
                                                                                            class="icofont icofont-ui-user"></i></span>
                                                                                    <input type="text" class="form-control"
                                                                                        placeholder="Dependant-Name "
                                                                                        name="price_per_night"
                                                                                        value="{{ old('name', $response->Dependant9) }}">
                                                                                </div>
                                                                                <x-input-error
                                                                                    :messages="$errors->get('price_per_night')"
                                                                                    class="mt-2" />

                                                                            </div>




                                                                        </div>
                                                                    </div>


                                                                    <div class="col-sm-4">
                                                                        <div class="row">

                                                                            <div class="col-sm-12">



                                                                                <div class="card">

                                                                                    <div class="card-header">
                                                                                        <h5>Image Upload</h5>

                                                                                    </div>
                                                                                    <div class="card-block">

                                                                                        <input type="file" name="images[]"
                                                                                            id="filer_input"
                                                                                            multiple="multiple">
                                                                                    </div>
                                                                                </div>


                                                                            </div>

                                                                        </div>
                                                                    </div>


                                                                    <div class="col-sm-2">
                                                                        <label for="">Residence</label>

                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-ui-home"></i></span>
                                                                            <select name="type"
                                                                                class="form-control form-control-primary">

                                                                                <option value="Rent">Rent House</option>
                                                                                <option value="Own">Own House</option>


                                                                            </select>
                                                                        </div>




                                                                    </div>

                                                                    <div class="col-sm-2">
                                                                        <label for="">Occupation</label>

                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-worker "></i></span>
                                                                            <select name="type"
                                                                                class="form-control form-control-primary">

                                                                                <option value="Own-business">Own business
                                                                                </option>
                                                                                <option value="Job">Job</option>


                                                                            </select>
                                                                        </div>




                                                                    </div>

                                                                    <div class="col-sm-2">
                                                                        <label for="">Income</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-money-bag"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="Income. e.g.20000"
                                                                                name="price_per_night"
                                                                                value="{{ old('name', $response->monthlyincome) }}">
                                                                        </div>
                                                                        <x-input-error
                                                                            :messages="$errors->get('price_per_night')"
                                                                            class="mt-2" />

                                                                    </div>




                                                                    <div class="col-sm-2">
                                                                        <label for="">Diseases</label>

                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-worker "></i></span>
                                                                            <select name="diseases"
                                                                                class="form-control form-control-primary">

                                                                              
                                                                                <option value="Yes" {{ old('diseases', $response->diseases) == 'Yes' ? 'selected' : '' }}>Yes</option>
                                                                                <option value="No" {{ old('diseases', $response->diseases) == 'No' ? 'selected' : '' }}>No</option>

                                                                            </select>
                                                                        </div>


                                                                        diseases

                                                                    </div>
















                                                                    <div class="col-sm-2">
                                                                        <label for="">Duration of the disease<span
                                                                                class="text-primary">(?)</span></label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-ui-timer"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="e.g. 1,2 years"
                                                                                name="cancellation_charges"
                                                                                value="{{ old('name', $response->diseasetimeperiod) }}">
                                                                        </div>
                                                                        <x-input-error
                                                                            :messages="$errors->get('cancellation_charges')"
                                                                            class="mt-2" />

                                                                    </div>


                                                                    <div class="col-sm-2">
                                                                        <label for="">Fee</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-money-bag"></i></span>
                                                                            <input type="text" class="form-control"
                                                                                placeholder="e.g. 500,1000"
                                                                                name="cancellation_charges"
                                                                                value="{{ old('name', $response->fee) }}">
                                                                        </div>
                                                                        <x-input-error
                                                                            :messages="$errors->get('cancellation_charges')"
                                                                            class="mt-2" />

                                                                    </div>













                                                                    <div class="col-sm-2">
                                                                        <label for="">Status</label>

                                                                        <div class="input-group">
                                                                            <span class="input-group-addon"><i
                                                                                    class="icofont icofont-worker "></i></span>
                                                                            <select name="type"
                                                                                class="form-control form-control-primary">

                                   
                                                                                <option value="Active" {{ old('status', $response->status) == 'Active' ? 'selected' : '' }}>Active</option>
                                                                                <option value="Inactive" {{ old('status', $response->status) == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                                                                            </select>
                                                                        </div>




                                                                    </div>






                                                                    <div class="col-sm-12">
                                                                        <textarea rows="5" cols="5" class="form-control"
                                                                            placeholder="Description about property"
                                                                            name="description">{{ old('name', $response->whatsapp) }}</textarea>
                                                                        <x-input-error
                                                                            :messages="$errors->get('description')"
                                                                            class="mt-2" />
                                                                    </div>
                                                                </div>

                                                                <div class="row">
                                                                    <div class="col-sm-12">
                                                                        <div class="text-center m-t-20">
                                                                            <button type="submit"
                                                                                class="btn btn-primary waves-effect waves-light m-r-10 btn-spinner">Save
                                                                            </button>
                                                                            <a href="{{route('cards.index')}}"
                                                                                class="btn btn-warning waves-effect waves-light btn-spinner">Discard
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Product edit card end -->
                            </div>
                        </div>
                    </div>
                    <!-- Page body end -->
                </div>
            </div>
            <!-- Main-body end -->
            <div id="styleSelector">

            </div>
        </div>
    </div>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#db_user_image_upload').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection