@extends('backend.layouts.main')
@section('title', 'User-Balance-Add')

@section('main-container')
    <div class="pcoded-content">
        <div class="pcoded-inner-content">
            <!-- Main-body start -->
            <div class="main-body">
                <div class="page-wrapper">
                    <!-- Page-header start -->
                    <div class="page-header">
                        <div class="row align-items-end">
                            <div class="col-lg-8">
                                <div class="page-header-title">
                                    <div class="d-inline">
                                        <h4>Add User-Balance</h4>
                                        <span>You can add balance from here</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="page-header-breadcrumb">
                                    <ul class="breadcrumb-title">
                                        <li class="breadcrumb-item">
                                            <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                        </li>
                                        <li class="breadcrumb-item"><a href="{{route('user-balance.index')}}">User-Balance</a>
                                        </li>
                                        <li class="breadcrumb-item"><a href="">Add</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Page-header end -->


                    <!-- Page body start -->
                    <div class="page-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <!-- Product edit card start -->
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Add Balance</h5>
                                        <h5>Current Balance: ({{$balance->balance_amount .'-'.$balance->currency_code}})</h5>
                                    </div>
                                    <div class="card-block">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="product-edit">
                                                    <ul class="nav nav-tabs nav-justified md-tabs " role="tablist">
                                                        <li class="nav-item">
                                                            <a class="nav-link active" data-toggle="tab" href="#home7"
                                                                role="tab">
                                                                <div class="f-20">
                                                                    <i class="icofont icofont-edit"></i>
                                                                </div>
                                                                Balance Information
                                                            </a>
                                                   
                                                        </li>

                                                    </ul>
                                                    <!-- Tab panes -->
                                <div class="tab-content">
                                    <div class="tab-pane active" id="home7" role="tabpanel">
                                        <form class="md-float-material card-block" action="{{route('userBalance.add',$balance->user->id)}}" method="post" enctype="multipart/form-data">
                                          @method('POST')
                                          @csrf
                                         

                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <label for=""> Amount </label>
                                                    <div class="input-group">
                                                        <span class="input-group-addon"><i
                                                                class="icofont icofont-ui-user"></i></span>
                                                        <input type="number" class="form-control"
                                                            placeholder="Amount" name="amount" value="{{old('amount')}}" autocomplete="off">
                                                    </div>
                                                    <x-input-error :messages="$errors->get('amount')" class="mt-2" />

                                                </div>

                                                {{-- <div class="col-sm-4">
                                                    <label for=""> Currency Code </label>
                                                    <div class="input-group">
                                                        <span class="input-group-addon"><i
                                                                class="icofont icofont-ui-user"></i></span>
                                                        <input type="text" class="form-control"
                                                            placeholder="Currency Code" name="currency_code" value="{{old('currency_code','USD')}}">
                                                    </div>
                                                    <x-input-error :messages="$errors->get('currency_code')" class="mt-2" />

                                                </div> --}}

                                                <div class="col-sm-4">
                                                    <label for=""> Payment Mode </label>
                                                    <select name="payment_mode"
                                                        class="form-control form-control-primary" required>
                                                        <option value="">Select Mode
                                                        </option>
                                                        <option value="card-payment">Card-Payment</option>

                                                        @can('manage all transactions')
                                                            
                                                        <option value="direct-deposit">Direct-Deposit</option>
                                                        @endcan

                                                        
                                                    </select>
                                                    <x-input-error :messages="$errors->get('payment_mode')" class="mt-2" />
                                                </div>

                                              
                                            </div>
                                            
 
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="text-center m-t-20">
                                                        <button type="submit"
                                                            class="btn btn-primary waves-effect waves-light m-r-10 btn-spinner">Save
                                                        </button>
                                                        <a href="{{route('user-balance.index')}}"
                                                            class="btn btn-warning waves-effect waves-light btn-spinner">Discard
                                                      </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>


                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Product edit card end -->
                            </div>
                        </div>
                    </div>
                    <!-- Page body end -->
                </div>
            </div>
            <!-- Main-body end -->
            <div id="styleSelector">

            </div>
        </div>
    </div>
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#db_user_image_upload').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection
