@extends('backend.layouts.main')
@section('title', 'Patient')

@section('main-container')
  
  
<div class="pcoded-content">
  <div class="pcoded-inner-content">
      <!-- Main-body start -->
      <div class="main-body">
          <div class="page-wrapper">
              <!-- Page-header start -->
              <div class="page-header">
                  <div class="row align-items-end">
                      <div class="col-lg-8">
                          <div class="page-header-title">
                              <div class="d-inline">
                                  <h4>All Customers</h4>
                                  <span>List of all Customers</span>
                              </div>
                          </div>
                         
                      </div>
                      <div class="col-lg-4">
                          <div class="page-header-breadcrumb">
                              <ul class="breadcrumb-title">
                                  <li class="breadcrumb-item">
                                      <a href="{{route('dashboard')}}"> <i class="feather icon-home"></i> </a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="#!">Customers</a>
                                  </li>
                                  <li class="breadcrumb-item"><a href="">All</a>
                                  </li>
                              </ul>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Page-header end -->
                  
                  <div class="page-body">
                    @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif
                    @if(session()->has('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                    @endif
                    <div class="card">
                      <div class="card-header">
                          <h5 class="card-header-text">Customers</h5>
                          
                      </div>
                     <form action="{{ route('report.store') }}" method="POST">
    @csrf
    <div class="card-block contact-details">
        <div class="data_table_main table-responsive dt-responsive">
            <table id="simpletable" class="table table-striped table-bordered nowrap">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Test</th>
                        <th>Reference Range</th>
                        <th>Results</th>
                    </tr>
                </thead>
                <tbody>

              <pre>
                 
              </pre>
                    @foreach ($report as $key => $value)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $value->testveriable }}</td>
                            <td>{{ $value->reference_mini_range }} - {{ $value->reference_max_range }} ({{ $value->unit }})</td>

                            <td>



 <input type="text"  name="test_id[{{ $value->id }}]" value="{{ $value->labtest->id }}" >
                                <input type="number" class="form-control" 
                                       name="results[{{ $value->id }}]" 
                                       value="{{ old('results.' . $value->id) }}" 
                                       style="width: 50px;">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <button type="submit" class="btn btn-primary mt-3">Submit</button>
</form>

                  </div>

                  </div>
              </div>
          </div>
          <!-- Warning Section Starts -->
         
      </div>
  </div> 


  @endsection
